/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates;

import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.intellij.core.connection.RepositoryInfo;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;

public class RepoEntry {
    public final String url;
    public final String username;
    public final String password;
    public final String accessToken;
    public final String name;
    public final String description;
    public boolean enabled;
    public RepositoryInfo info;

    public RepoEntry(String url, String username, String password, String accessToken, String name, String description) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.accessToken = accessToken;
        this.name = name;
        this.description = description;
        this.enabled = true;
    }

    public RepoEntry(RepositoryInfo info) {
        this.url = info.getURL();
        this.username = null;
        this.password = null;
        this.accessToken = null;
        this.name = info.getName();
        this.description = info.getDescription();
        this.enabled = info.getEnabled();
        this.info = info;
    }

    public boolean isProtected() {
        if (this.info != null) {
            return this.info.isProtected();
        }
        return false;
    }

    public String getStyles() {
        if (this.info != null) {
            List<String> styles = this.info.getStyles();
            if (styles == null || styles.isEmpty()) {
                return CodewindUIBundle.message("GenericNotAvailable", new Object[0]);
            }
            StringBuilder builder = new StringBuilder();
            boolean start = true;
            Iterator<String> iterator = styles.iterator();
            if (iterator.hasNext()) {
                String style = iterator.next();
                if (!start) {
                    builder.append(", ");
                } else {
                    start = false;
                }
                builder.append(style);
                return builder.toString();
            }
        }
        return CodewindUIBundle.message("GenericNotAvailable", new Object[0]);
    }
}

