/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates.form;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.TemplateUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.RepositoryInfo;
import org.eclipse.codewind.intellij.ui.form.WidgetUtils;
import org.eclipse.codewind.intellij.ui.form.WizardHeaderForm;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.templates.AbstractAddTemplateSourceWizardStep;
import org.eclipse.codewind.intellij.ui.templates.AddTemplateSourceWizard;
import org.eclipse.codewind.intellij.ui.templates.AddTemplateSourceWizardModel;
import org.eclipse.codewind.intellij.ui.templates.DetailsStep;
import org.eclipse.codewind.intellij.ui.templates.EditTemplateSourceWizard;
import org.eclipse.codewind.intellij.ui.templates.RepoEntry;
import org.eclipse.codewind.intellij.ui.templates.UrlStep;
import org.jetbrains.annotations.NotNull;

public class RepositoryManagementForm {
    private JPanel contentPane;
    private JPanel rowPanel;
    private JTable repoViewer;
    private JButton addButton;
    private JButton removeButton;
    private JScrollPane tableScrollPane;
    private JPanel buttonPanel;
    private JLabel descLabel;
    private JTextPane descTextPane;
    private JLabel styleLabel;
    private JLabel urlLabel;
    private JPanel detailsPanel;
    private JTextPane styleTextPane;
    private JTextPane urlTextPane;
    private JPanel headerPanel;
    private JPanel mainContent;
    private JTextPane descriptionTextPane;
    private JButton editButton;
    private List<RepositoryInfo> repoList;
    private CodewindConnection connection;
    private Project project;
    private List<RepoEntry> repoEntries;
    private RepoViewerModel repoViewerModel;

    public RepositoryManagementForm(Project project, CodewindConnection connection, List<RepositoryInfo> repoList) {
        this.project = project;
        this.connection = connection;
        this.repoList = repoList;
        this.$$$setupUI$$$();
    }

    public void initForm() {
        this.repoEntries = this.getRepoEntries(this.repoList);
        if (this.repoViewer instanceof RepoViewer) {
            ((RepoViewer)this.repoViewer).init();
            ((RepoViewer)this.repoViewer).setRepoEntries(this.repoEntries);
            if (this.repoEntries.size() > 0) {
                this.repoViewer.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void createUIComponents() {
        WizardHeaderForm headerForm = new WizardHeaderForm(CodewindUIBundle.message("RepoMgmtDialogTitle", new Object[0]), CodewindUIBundle.message("RepoMgmtDialogMessage", new Object[0]));
        this.headerPanel = headerForm.getContentPane();
        this.descriptionTextPane = new JTextPane();
        this.repoViewer = new RepoViewer();
        this.tableScrollPane = new JBScrollPane((Component)this.repoViewer);
        this.tableScrollPane.setPreferredSize(new Dimension(600, 200));
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.descriptionTextPane.setText(CodewindUIBundle.message("RepoMgmtDescription", new Object[0]));
        this.addButton.setText(CodewindUIBundle.message("RepoMgmtAddButton", new Object[0]));
        this.editButton.setText(CodewindUIBundle.message("RepoMgmtEditButton", new Object[0]));
        this.removeButton.setText(CodewindUIBundle.message("RepoMgmtRemoveButton", new Object[0]));
        this.detailsPanel = new JPanel();
        this.descTextPane = WidgetUtils.createTextPane("", true);
        this.styleTextPane = WidgetUtils.createTextPane("", true);
        this.urlTextPane = WidgetUtils.createHyperlinkUsingTextPane("", true);
        this.addButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RepoEntry repoEntry;
                ArrayList<AbstractAddTemplateSourceWizardStep> steps = new ArrayList<AbstractAddTemplateSourceWizardStep>();
                AddTemplateSourceWizardModel wizardModel = new AddTemplateSourceWizardModel();
                wizardModel.setRepoEntries(RepositoryManagementForm.this.repoEntries);
                UrlStep urlStep = new UrlStep(RepositoryManagementForm.this.project, RepositoryManagementForm.this.connection, wizardModel);
                steps.add(urlStep);
                steps.add(new DetailsStep(RepositoryManagementForm.this.project, RepositoryManagementForm.this.connection, wizardModel));
                wizardModel.addSteps(steps);
                AddTemplateSourceWizard wizard = new AddTemplateSourceWizard(RepositoryManagementForm.this.project, steps);
                urlStep.addListener(wizard);
                boolean rc = wizard.showAndGet();
                if (rc && (repoEntry = wizard.getRepoEntry()) != null) {
                    RepositoryManagementForm.this.repoEntries.add(repoEntry);
                    RepositoryManagementForm.this.repoViewerModel.fireTableDataChanged();
                }
            }
        });
        this.editButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RepoEntry newRepoEntry;
                int selectedIndex = RepositoryManagementForm.this.repoViewer.getSelectedRow();
                RepoEntry selectedRepo = (RepoEntry)RepositoryManagementForm.this.repoEntries.get(selectedIndex);
                ArrayList<AbstractAddTemplateSourceWizardStep> steps = new ArrayList<AbstractAddTemplateSourceWizardStep>();
                AddTemplateSourceWizardModel wizardModel = new AddTemplateSourceWizardModel();
                wizardModel.setRepoEntries(RepositoryManagementForm.this.repoEntries);
                wizardModel.setNameValue(selectedRepo.name);
                wizardModel.setDescriptionValue(selectedRepo.description);
                wizardModel.setIsEdit(true);
                wizardModel.setUrlValue(selectedRepo.url);
                UrlStep urlStep = new UrlStep(RepositoryManagementForm.this.project, RepositoryManagementForm.this.connection, wizardModel);
                steps.add(urlStep);
                steps.add(new DetailsStep(RepositoryManagementForm.this.project, RepositoryManagementForm.this.connection, wizardModel));
                wizardModel.addSteps(steps);
                EditTemplateSourceWizard wizard = new EditTemplateSourceWizard(RepositoryManagementForm.this.project, steps);
                urlStep.addListener(wizard);
                boolean rc = wizard.showAndGet();
                if (rc && (newRepoEntry = wizard.getRepoEntry()) != null) {
                    newRepoEntry.enabled = selectedRepo.enabled;
                    RepositoryManagementForm.this.repoEntries.set(selectedIndex, newRepoEntry);
                    RepositoryManagementForm.this.repoViewerModel.fireTableDataChanged();
                    RepositoryManagementForm.this.repoViewer.setRowSelectionInterval(selectedIndex, selectedIndex);
                }
            }
        });
        this.removeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int[] selectedIndices = RepositoryManagementForm.this.repoViewer.getSelectedRows();
                if (selectedIndices.length > 0) {
                    ArrayList itemsToRemove = new ArrayList();
                    for (int i = 0; i < selectedIndices.length; ++i) {
                        itemsToRemove.add(RepositoryManagementForm.this.repoEntries.get(selectedIndices[i]));
                    }
                    Arrays.stream(itemsToRemove.toArray()).forEach(item -> RepositoryManagementForm.this.repoEntries.remove(item));
                    RepositoryManagementForm.this.repoViewerModel.fireTableDataChanged();
                }
            }
        });
    }

    private void updateDetails() {
        String desc = "";
        String styles = "";
        String url = "";
        boolean enabled = false;
        if (this.repoViewer.getSelectedRowCount() == 1) {
            RepoEntry repoEntry = this.repoEntries.get(this.repoViewer.getSelectedRow());
            boolean bl = enabled = repoEntry != null;
            if (enabled) {
                desc = repoEntry.description;
                styles = repoEntry.getStyles();
                url = repoEntry.url;
            }
        }
        this.descLabel.setEnabled(enabled);
        this.descTextPane.setText(desc);
        this.styleLabel.setEnabled(enabled);
        this.styleTextPane.setText(styles);
        this.urlLabel.setEnabled(enabled);
        if (url.length() == 0) {
            this.urlTextPane.setContentType("text/string");
            this.urlTextPane.setText(url);
        } else {
            this.urlTextPane.setContentType("text/html");
            this.urlTextPane.setText("<a href=\"" + url + "\">" + url + "</a>");
        }
    }

    private void updateButtons() {
        boolean enabled = true;
        if (this.repoViewer.getSelectedRowCount() > 0) {
            int[] selectedRows = this.repoViewer.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                RepoEntry repoEntry = this.repoEntries.get(selectedRows[i]);
                if (!repoEntry.isProtected()) continue;
                enabled = false;
                break;
            }
        } else {
            enabled = false;
        }
        this.removeButton.setEnabled(enabled);
        this.editButton.setEnabled(this.repoViewer.getSelectedRowCount() == 1 && enabled);
    }

    public ValidationInfo doValidate() {
        return null;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    private List<RepoEntry> getRepoEntries(List<RepositoryInfo> infos) {
        if (infos == null) {
            return new ArrayList<RepoEntry>(0);
        }
        ArrayList<RepoEntry> entries = new ArrayList<RepoEntry>(infos.size());
        for (RepositoryInfo info : infos) {
            entries.add(new RepoEntry(info));
        }
        return entries;
    }

    public void updateRepos() {
        if (!this.hasChanges()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.project, CodewindUIBundle.message("RepoUpdateTask", new Object[0]), true){

            public void run(@NotNull ProgressIndicator mon) {
                if (mon == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (RepositoryInfo info : RepositoryManagementForm.this.repoList) {
                    Optional entry = RepositoryManagementForm.this.getRepoEntry(info);
                    if (!entry.isPresent()) {
                        try {
                            TemplateUtil.removeTemplateSource(info.getURL(), RepositoryManagementForm.this.connection.getConid(), mon);
                        }
                        catch (Exception e) {
                            Logger.logWarning("Failed to remove repository: " + info.getURL(), e);
                        }
                    } else if (info.getEnabled() != ((RepoEntry)entry.get()).enabled) {
                        try {
                            TemplateUtil.enableTemplateSource(((RepoEntry)entry.get()).enabled, info.getURL(), RepositoryManagementForm.this.connection.getConid(), mon);
                        }
                        catch (Exception e) {
                            Logger.logWarning("Failed to update repository: " + info.getURL(), e);
                        }
                    }
                    if (!mon.isCanceled()) continue;
                    return;
                }
                for (RepoEntry entry : RepositoryManagementForm.this.repoEntries) {
                    if (entry.info == null) {
                        try {
                            TemplateUtil.addTemplateSource(entry.url, entry.username, entry.password, entry.accessToken, entry.name, entry.description, RepositoryManagementForm.this.connection.getConid(), mon);
                        }
                        catch (Exception e) {
                            Logger.logWarning("Failed to add repository: " + entry.url, e);
                            CoreUtil.openDialog(true, CodewindUIBundle.message("RepoMgmtAddFailed", entry.url), e.getLocalizedMessage());
                        }
                    }
                    if (!mon.isCanceled()) continue;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mon", "org/eclipse/codewind/intellij/ui/templates/form/RepositoryManagementForm$4", "run"));
            }
        }));
    }

    public boolean hasChanges() {
        for (RepositoryInfo info : this.repoList) {
            Optional<RepoEntry> entry = this.getRepoEntry(info);
            if (!entry.isPresent()) {
                return true;
            }
            if (info.getEnabled() == entry.get().enabled) continue;
            return true;
        }
        for (RepoEntry entry : this.repoEntries) {
            if (entry.info != null) continue;
            return true;
        }
        return false;
    }

    private Optional<RepoEntry> getRepoEntry(RepositoryInfo info) {
        return this.repoEntries.stream().filter(entry -> entry.info == info).findFirst();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.contentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = this.headerPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.mainContent = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.rowPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane = this.tableScrollPane;
        jPanel2.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JTable jTable = this.repoViewer;
        jScrollPane.setViewportView(jTable);
        this.buttonPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JButton jButton = this.addButton;
        jPanel.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JButton jButton2 = this.removeButton;
        jPanel.add((Component)jButton2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 2, null, null, null));
        JButton jButton3 = this.editButton;
        jPanel.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = this.detailsPanel;
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setFocusable(false);
        jPanel6.setOpaque(false);
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.descLabel = jLabel3 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel3.getFont());
        if (font != null) {
            jLabel3.setFont(font);
        }
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("RepoMgmtDescriptionLabel"));
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JTextPane jTextPane = this.descTextPane;
        jTextPane.setEditable(false);
        jTextPane.setMargin(new Insets(5, 5, 5, 5));
        jTextPane.setOpaque(false);
        jPanel6.add((Component)jTextPane, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, new Dimension(150, 68), null));
        this.styleLabel = jLabel2 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font2 != null) {
            jLabel2.setFont(font2);
        }
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("RepoMgmtStylesLabel"));
        jPanel6.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextPane jTextPane2 = this.styleTextPane;
        jTextPane2.setEditable(false);
        jTextPane2.setMargin(new Insets(5, 5, 5, 5));
        jTextPane2.setOpaque(false);
        jPanel6.add((Component)jTextPane2, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 0, null, new Dimension(150, 20), null));
        this.urlLabel = jLabel = new JLabel();
        Font font3 = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font3 != null) {
            jLabel.setFont(font3);
        }
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("RepoMgmtUrlLabel"));
        jPanel6.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextPane jTextPane3 = this.urlTextPane;
        jTextPane3.setEditable(false);
        jTextPane3.setMargin(new Insets(5, 5, 5, 5));
        jTextPane3.setOpaque(false);
        jPanel6.add((Component)jTextPane3, new GridConstraints(5, 0, 1, 1, 1, 1, 3, 3, null, new Dimension(150, 50), null));
        JTextPane jTextPane4 = this.descriptionTextPane;
        jPanel3.add((Component)jTextPane4, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 0, null, new Dimension(150, 50), null));
        jLabel2.setLabelFor(jTextPane2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class RepoViewer
    extends JTable {
        private List<ListSelectionListener> selectionListeners = new ArrayList<ListSelectionListener>();

        public void setRepoEntries(List<RepoEntry> repoEntries) {
            RepositoryManagementForm.this.repoViewerModel.setRepoEntries(repoEntries);
        }

        public void init() {
            this.setFillsViewportHeight(true);
            this.setShowGrid(true);
            this.setColumnSelectionAllowed(false);
            this.setSelectionMode(2);
            JTableHeader tableHeader = new JTableHeader();
            tableHeader.setTable(this);
            tableHeader.setReorderingAllowed(false);
            this.setTableHeader(tableHeader);
            DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
            TableColumn checkboxColumn = new TableColumn();
            checkboxColumn.setPreferredWidth(50);
            checkboxColumn.setMaxWidth(100);
            checkboxColumn.setModelIndex(0);
            checkboxColumn.setHeaderValue(null);
            columnModel.addColumn(checkboxColumn);
            TableColumn nameColumn = new TableColumn();
            nameColumn.setModelIndex(1);
            nameColumn.setHeaderValue(null);
            columnModel.addColumn(nameColumn);
            RepositoryManagementForm.this.repoViewerModel = new RepoViewerModel();
            this.setModel(RepositoryManagementForm.this.repoViewerModel);
            this.setColumnModel(columnModel);
            this.setTableHeader(null);
            this.setRowHeight(this.getRowHeight() + 5);
            ListSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.addListSelectionListener(listSelectionEvent -> {
                RepositoryManagementForm.this.updateDetails();
                RepositoryManagementForm.this.updateButtons();
                if (this.selectionListeners.size() > 0) {
                    for (ListSelectionListener listener : this.selectionListeners) {
                        listener.valueChanged(listSelectionEvent);
                    }
                }
            });
        }
    }

    private class RepoViewerModel
    extends AbstractTableModel {
        private List<RepoEntry> repoEntries;

        public void setRepoEntries(List<RepoEntry> repoEntries) {
            this.repoEntries = repoEntries;
        }

        @Override
        public int getRowCount() {
            if (this.repoEntries != null) {
                return this.repoEntries.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            super.setValueAt(o, row, col);
            if (o instanceof Boolean) {
                RepoEntry repoEntry = this.repoEntries.get(row);
                repoEntry.enabled = (Boolean)o;
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            RepoEntry repoEntry = this.repoEntries.get(row);
            if (col == 0) {
                return repoEntry.enabled;
            }
            if (col == 1) {
                String name = repoEntry.name;
                if (name == null || name.isEmpty()) {
                    name = repoEntry.description;
                }
                return name;
            }
            return null;
        }
    }
}

