/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.cli;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.ProcessHelper;
import org.eclipse.codewind.intellij.core.cli.AuthToken;
import org.eclipse.codewind.intellij.core.cli.CLIUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthUtil {
    private static final String[] SECKEYRING_UPDATE_CMD = new String[]{"seckeyring", "update"};
    private static final String[] SECTOKEN_GET_CMD = new String[]{"sectoken", "get"};
    private static final String USERNAME_OPTION = "--username";
    private static final String PASSWORD_OPTION = "--password";
    private static final String STATUS_KEY = "status";
    private static final String STATUS_MSG_KEY = "status_message";
    private static final String STATUS_OK_VALUE = "OK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthToken getAuthToken(String username, String password, String conid, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        monitor.setIndeterminate(true);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(null, SECKEYRING_UPDATE_CMD, new String[]{USERNAME_OPTION, username, PASSWORD_OPTION, password, "--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60);
            if (result.getExitValue() != 0) {
                Logger.logWarning("Seckeyring update failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logWarning("Seckeyring update had 0 return code but the output is empty");
                throw new IOException("The output from seckeyring update is empty.");
            }
            JSONObject resultJson = new JSONObject(result.getOutput());
            if (!STATUS_OK_VALUE.equals(resultJson.getString(STATUS_KEY))) {
                String msg = "Seckeyring update failed for: " + conid + " with output: " + resultJson.getString(STATUS_MSG_KEY);
                Logger.logWarning(msg);
                throw new IOException(msg);
            }
            AuthToken authToken = AuthUtil.getAuthToken(username, conid, null);
            return authToken;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthToken getAuthToken(String username, String conid, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        if (monitor != null) {
            monitor.setIndeterminate(true);
        }
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_INSECURE, SECTOKEN_GET_CMD, new String[]{USERNAME_OPTION, username, "--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60);
            if (result.getExitValue() != 0) {
                Logger.logWarning("Sectoken get failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logWarning("Sectoken get had 0 return code but the output is empty");
                throw new IOException("The output from sectoken get is empty.");
            }
            AuthToken authToken = new AuthToken(new JSONObject(result.getOutput()));
            return authToken;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

