/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.TemplateUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ProjectTemplateInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.module.CodewindModuleBuilder;
import org.eclipse.codewind.intellij.ui.module.TemplateTableModel;

public class NewCodewindProjectStep
extends ModuleWizardStep {
    private final CodewindModuleBuilder builder;
    private CodewindConnection connection;
    private final JPanel panel;
    private final JTable table;

    public NewCodewindProjectStep(CodewindModuleBuilder builder) {
        this.builder = builder;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        JLabel label = new JLabel(CodewindUIBundle.message("NewProjectPage_WizardTitle", new Object[0]));
        label.setAlignmentX(0.0f);
        this.panel.add(label);
        this.table = new JBTable((TableModel)new TemplateTableModel());
        JBScrollPane scroll = new JBScrollPane((Component)this.table);
        scroll.setAlignmentX(0.0f);
        this.panel.add((Component)scroll);
    }

    public void setConnection(CodewindConnection connection) {
        this.connection = connection;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updateDataModel() {
        this.builder.setSelectedTemplate(this.getTableModel().getTemplateAt(this.table.getSelectedRow()));
    }

    public void updateStep() {
        try {
            String javaID = ProjectLanguage.LANGUAGE_JAVA.getId();
            String conId = "local";
            if (this.connection != null) {
                conId = this.connection.getConid();
            }
            List<ProjectTemplateInfo> templates = TemplateUtil.listTemplates(true, conId, (ProgressIndicator)new EmptyProgressIndicator()).stream().filter(info -> info.getLanguage().equals(javaID)).collect(Collectors.toList());
            this.getTableModel().update(templates);
        }
        catch (Exception e) {
            Logger.logWarning(e);
        }
    }

    public boolean validate() throws ConfigurationException {
        return this.table.getSelectedRow() >= 0;
    }

    public void onWizardFinished() throws CommitStepException {
        this.builder.onWizardFinished();
    }

    private TemplateTableModel getTableModel() {
        return (TemplateTableModel)this.table.getModel();
    }
}

