/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.connection;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CodewindManager;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.ConnectionUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;

public class ConnectionManager {
    private static ConnectionManager instance;
    private final LocalConnection localConnection;
    private List<CodewindConnection> connections = new ArrayList<CodewindConnection>();

    private ConnectionManager() {
        this.localConnection = CodewindConnection.createLocalConnection();
        this.add(this.localConnection);
        CoreUtil.runAsync(() -> {
            try {
                CodewindManager.getManager().refreshInstallStatus();
                CoreUtil.updateAll();
            }
            catch (Exception e) {
                Logger.logWarning("An error occurred trying to connect to the local Codewind instance at:" + this.localConnection.getBaseURI(), e);
            }
        });
    }

    public static synchronized ConnectionManager getManager() {
        if (instance == null) {
            instance = new ConnectionManager();
        }
        return instance;
    }

    public LocalConnection getLocalConnection() {
        return this.localConnection;
    }

    public synchronized void add(CodewindConnection connection) {
        if (connection == null) {
            Logger.logWarning("Null connection passed to be added");
            return;
        }
        this.connections.add(connection);
        Logger.log("Added a new connection: " + connection.getBaseURI());
    }

    public synchronized List<CodewindConnection> activeConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public synchronized CodewindConnection getActiveConnection(String baseUrl) {
        for (CodewindConnection mcc : this.activeConnections()) {
            if (!mcc.getBaseURI().toString().equals(baseUrl)) continue;
            return mcc;
        }
        return null;
    }

    public synchronized CodewindConnection getActiveConnectionByName(String name) {
        for (CodewindConnection conn : this.activeConnections()) {
            if (name == null || !name.equals(conn.getName())) continue;
            return conn;
        }
        return null;
    }

    public synchronized int activeConnectionsCount() {
        return this.connections.size();
    }

    public synchronized boolean remove(String baseUrl) {
        boolean removeResult = false;
        CodewindConnection connection = this.getActiveConnection(baseUrl.toString());
        if (connection != null) {
            List<CodewindApplication> apps = connection.getApps();
            connection.close();
            removeResult = this.connections.remove(connection);
            CoreUtil.removeConnection(apps);
            if (connection.getConid() != null) {
                try {
                    ConnectionUtil.removeConnection(connection.getConid(), (ProgressIndicator)new EmptyProgressIndicator());
                }
                catch (Exception e) {
                    Logger.logWarning("An error occurred trying to de-register the connection: " + connection.getName());
                }
            }
        }
        if (!removeResult) {
            Logger.logWarning("Tried to remove connection " + baseUrl + ", but it didn't exist");
        }
        CoreUtil.updateAll();
        return removeResult;
    }

    public synchronized void clear() {
        Logger.log("Clearing " + this.connections.size() + " connections");
        Iterator<CodewindConnection> it = this.connections.iterator();
        while (it.hasNext()) {
            CodewindConnection connection = it.next();
            connection.close();
            it.remove();
        }
    }
}

