/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.constants;

import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;

public enum BuildStatus {
    IN_PROGRESS("inProgress", CodewindCoreBundle.message("BuildStateInProgress", new Object[0])),
    SUCCESS("success", CodewindCoreBundle.message("BuildStateSuccess", new Object[0])),
    FAILED("failed", CodewindCoreBundle.message("BuildStateFailed", new Object[0])),
    QUEUED("queued", CodewindCoreBundle.message("BuildStateQueued", new Object[0])),
    UNKOWN("unknown", CodewindCoreBundle.message("BuildStateUnknown", new Object[0]));

    public static final String BUILD_REQUIRED = "buildRequired";
    public final String status;
    public final String displayString;

    private BuildStatus(String buildStatus, String displayString) {
        this.status = buildStatus;
        this.displayString = displayString;
    }

    public static BuildStatus get(String buildStatus) {
        if (BUILD_REQUIRED.equals(buildStatus)) {
            return null;
        }
        for (BuildStatus status : BuildStatus.values()) {
            if (!status.status.equals(buildStatus)) continue;
            return status;
        }
        Logger.logWarning("Unrecognized application state: " + buildStatus);
        return UNKOWN;
    }

    public boolean isComplete() {
        return this == SUCCESS || this == FAILED;
    }

    public String getDisplayString() {
        return this.displayString;
    }
}

