/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates.form;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.codewind.intellij.core.IAuthInfo;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.form.WidgetUtils;
import org.eclipse.codewind.intellij.ui.form.WizardHeaderForm;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.templates.form.AuthForm;
import org.eclipse.codewind.intellij.ui.wizard.BaseCodewindForm;
import org.jetbrains.annotations.NotNull;

public class UrlForm
extends BaseCodewindForm
implements ChangeListener {
    private JPanel contentPane;
    private JPanel rowPanel;
    private JLabel urlLabel;
    private JTextField urlTextField;
    private JCheckBox authCheckBox;
    private JPanel headerPanel;
    private JPanel mainContent;
    private JPanel authPanel;
    private AuthForm authForm;
    private CodewindConnection connection;
    private Project project;
    private String urlValue = "";
    private boolean isAuth = false;

    public UrlForm(Project project, CodewindConnection connection, boolean isAuth, String urlValue) {
        this.project = project;
        this.connection = connection;
        this.isAuth = isAuth;
        this.urlValue = urlValue;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        WizardHeaderForm headerForm = new WizardHeaderForm(CodewindUIBundle.message("AddRepoDialogUrlLocation", new Object[0]), CodewindUIBundle.message("AddRepoURLPageMessage", new Object[0]));
        this.headerPanel = headerForm.getContentPane();
        this.urlTextField = new JBTextField();
        this.authCheckBox = new JBCheckBox();
        this.authCheckBox.setSelected(this.isAuth);
        this.authCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == UrlForm.this.authCheckBox && !mouseEvent.isPopupTrigger()) {
                    UrlForm.this.isAuth = !UrlForm.this.isAuth;
                    UrlForm.this.authForm.setEnabled(UrlForm.this.isAuth);
                    UrlForm.this.fireStateChanged(new ChangeEvent(UrlForm.this.authCheckBox));
                }
            }
        });
        this.urlTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                UrlForm.this.urlValue = WidgetUtils.getTextValue(UrlForm.this.urlTextField);
                UrlForm.this.authForm.setUrlValue(UrlForm.this.urlValue);
                UrlForm.this.fireStateChanged(new ChangeEvent(UrlForm.this.urlTextField));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/templates/form/UrlForm$2", "textChanged"));
            }
        });
        this.authPanel = new JPanel();
        this.authForm = new AuthForm(this.project, this.connection, true, false);
        this.authForm.addListener(this);
        if (this.urlValue != null) {
            this.urlTextField.setText(this.urlValue);
        }
        this.authForm.setEnabled(this.isAuth);
    }

    public String getTemplateSourceUrl() {
        return WidgetUtils.getTextValue(this.urlTextField);
    }

    public JTextField getTemplateSourceTextField() {
        return this.urlTextField;
    }

    public ValidationInfo doValidate() {
        return null;
    }

    public boolean isComplete() {
        return this.urlValue != null ? this.urlValue.length() > 0 : false;
    }

    public AuthForm getAuthForm() {
        return this.authForm;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public IAuthInfo getAuthInfo() {
        if (this.isAuth) {
            return this.authForm.getAuthInfo();
        }
        return null;
    }

    public String getUsername() {
        return this.authForm.getUsername();
    }

    public String getPassword() {
        return this.authForm.getPassword();
    }

    public String getToken() {
        return this.authForm.getToken();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = this.headerPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.mainContent = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.rowPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.urlLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogUrlLabel"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField = this.urlTextField;
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(450, -1), null));
        JCheckBox jCheckBox = this.authCheckBox;
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogAuthRequiredCheckboxLabel"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = this.authPanel;
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(3, 10, 3, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        AuthForm authForm = this.authForm;
        JComponent jComponent = authForm.$$$getRootComponent$$$();
        jPanel5.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

