/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.wizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ProjectTypeInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.ui.form.ProjectTypeSelectionForm;
import org.eclipse.codewind.intellij.ui.wizard.AbstractBindProjectWizardStep;
import org.eclipse.codewind.intellij.ui.wizard.BindProjectModel;
import org.eclipse.codewind.intellij.ui.wizard.ConfirmProjectTypeStep;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTypeSelectionStep
extends AbstractBindProjectWizardStep {
    public static String STEP_ID = "ProjectTypeSelectionStep";
    private ProjectTypeSelectionForm form;
    private Project project;
    private CodewindConnection connection;
    private ProjectInfo initialProjectInfo;

    public ProjectTypeSelectionStep(@Nullable String title, Project project, CodewindConnection connection) {
        super(title);
        this.project = project;
        this.connection = connection;
    }

    @NotNull
    public Object getStepId() {
        String string = STEP_ID;
        if (string == null) {
            ProjectTypeSelectionStep.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Object getNextStepId() {
        return null;
    }

    @Nullable
    public Object getPreviousStepId() {
        return ConfirmProjectTypeStep.STEP_ID;
    }

    public boolean isComplete() {
        ProjectTypeInfo selectedProjectTypeInfo = this.form.getSelectedProjectTypeInfo();
        ProjectTypeInfo.ProjectSubtypeInfo selectedSubtype = this.form.getSelectedSubtype();
        if (selectedProjectTypeInfo != null) {
            if (!(selectedProjectTypeInfo.eq(ProjectType.TYPE_DOCKER) || this.initialProjectInfo != null && selectedProjectTypeInfo.eq(this.initialProjectInfo.type))) {
                return selectedSubtype != null;
            }
            return true;
        }
        return false;
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
    }

    public JComponent getComponent() {
        if (this.form != null) {
            return this.form.getContentPane();
        }
        this.form = new ProjectTypeSelectionForm(this);
        return this.form.getContentPane();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public void updateProjectTypeMap(final BindProjectModel model) {
        if (model.getTypes() == null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    Map types = ProjectTypeSelectionStep.this.getProjectTypeMap();
                    model.setTypes(types);
                    ProjectTypeSelectionStep.this.form.updateProjectTypesList(true, types);
                    ProjectTypeSelectionStep.this.form.setProjectTypes(types);
                }
            }, "Getting project types", false, this.project);
        }
    }

    private Map<String, ProjectTypeInfo> getProjectTypeMap() {
        List<ProjectTypeInfo> projectTypes = null;
        HashMap<String, ProjectTypeInfo> typeMap = new HashMap<String, ProjectTypeInfo>();
        try {
            projectTypes = this.connection.requestProjectTypes();
        }
        catch (Exception e) {
            return typeMap;
        }
        if (projectTypes == null || projectTypes.isEmpty()) {
            return typeMap;
        }
        for (ProjectTypeInfo projectType : projectTypes) {
            ProjectTypeInfo existing = (ProjectTypeInfo)typeMap.get(projectType.getId());
            if (existing == null) {
                typeMap.put(projectType.getId(), projectType);
                continue;
            }
            existing.addSubtypes(projectType.getSubtypes());
        }
        return typeMap;
    }

    private void setInitialProjectInfo(ProjectInfo initialProjectInfo) {
        this.initialProjectInfo = initialProjectInfo;
        this.form.setInitialProjectInfo(this.initialProjectInfo);
    }

    @Override
    protected void onStepEntering(BindProjectModel model) {
        this.setInitialProjectInfo(model.getProjectInfo());
        this.updateProjectTypeMap(model);
    }

    @Override
    protected void onStepLeaving(BindProjectModel model) {
        model.setProjectTypeInfo(this.form.getSelectedProjectTypeInfo());
        model.setSubtypeInfo(this.form.getSelectedSubtype());
    }

    @Override
    protected void postDoNextStep(BindProjectModel model) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void addListener(ChangeListener listener) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/ui/wizard/ProjectTypeSelectionStep", "getStepId"));
    }
}

