/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates.form;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.form.WidgetUtils;
import org.eclipse.codewind.intellij.ui.form.WizardHeaderForm;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.wizard.BaseCodewindForm;
import org.jetbrains.annotations.NotNull;

public class DetailsForm
extends BaseCodewindForm {
    private JPanel contentPane;
    private JPanel headerPanel;
    private JPanel mainContent;
    private JPanel rowPanel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JPanel rowButtonPanel;
    private JButton resetButton;
    private CodewindConnection connection;
    private String nameValue;
    private String descriptionValue;
    private Project project;
    private String[] defaultValues = new String[2];

    public DetailsForm(Project project, CodewindConnection connection, String nameValue, String descriptionValue) {
        this.project = project;
        this.connection = connection;
        this.nameValue = nameValue;
        this.descriptionValue = descriptionValue;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        WizardHeaderForm headerForm = new WizardHeaderForm(CodewindUIBundle.message("AddRepoDetailsPage", new Object[0]), CodewindUIBundle.message("AddRepoDetailsPageMessage", new Object[0]));
        this.headerPanel = headerForm.getContentPane();
        this.nameTextField = new JBTextField();
        this.descriptionTextField = new JBTextField();
        if (this.nameValue != null) {
            this.nameTextField.setText(this.nameValue);
        }
        if (this.descriptionValue != null) {
            this.descriptionTextField.setText(this.descriptionValue);
        }
        this.resetButton = new JButton();
        this.resetButton.setText(CodewindUIBundle.message("AddRepoDialogResetButtonLabel", new Object[0]));
        this.resetButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    DetailsForm.this.nameTextField.setText(DetailsForm.this.defaultValues[0] == null ? "" : DetailsForm.this.defaultValues[0]);
                    DetailsForm.this.descriptionTextField.setText(DetailsForm.this.defaultValues[1] == null ? "" : DetailsForm.this.defaultValues[1]);
                    DetailsForm.this.validate(false, DetailsForm.this.resetButton);
                }
                catch (Exception e) {
                    Logger.logDebug("An error occurred trying to get the template source details", e);
                }
            }
        });
        this.nameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DetailsForm.this.validate(false, DetailsForm.this.nameTextField);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/templates/form/DetailsForm$2", "textChanged"));
            }
        });
        this.descriptionTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DetailsForm.this.validate(false, DetailsForm.this.descriptionTextField);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/templates/form/DetailsForm$3", "textChanged"));
            }
        });
    }

    public ValidationInfo doValidate() {
        if (this.nameTextField.getText().length() == 0) {
            return new ValidationInfo(CodewindUIBundle.message("AddRepoDialogNoName", new Object[0]));
        }
        if (this.descriptionTextField.getText().length() == 0) {
            return new ValidationInfo(CodewindUIBundle.message("AddRepoDialogNoDescription", new Object[0]));
        }
        return null;
    }

    public boolean isComplete() {
        return this.nameTextField.getText().length() > 0 && this.descriptionTextField.getText().length() > 0;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public String getTemplateSourceName() {
        return WidgetUtils.getTextValue(this.nameTextField);
    }

    public String getTemplateSourceDescription() {
        return WidgetUtils.getTextValue(this.descriptionTextField);
    }

    private void validate(boolean init, JComponent component) {
        String errorMsg = null;
        this.nameValue = WidgetUtils.getTextValue(this.nameTextField);
        this.descriptionValue = WidgetUtils.getTextValue(this.descriptionTextField);
        this.resetButton.setVisible(this.defaultValues[0] != null);
        if (this.resetButton.isVisible()) {
            this.resetButton.setEnabled(this.nameValue == null && this.defaultValues[0] != null || this.nameValue != null && !this.nameValue.equals(this.defaultValues[0]) || this.descriptionValue == null && this.defaultValues[1] != null || this.descriptionValue != null && !this.descriptionValue.equals(this.defaultValues[1]));
        }
        if (this.nameValue == null) {
            errorMsg = CodewindUIBundle.message("AddRepoDialogNoName", new Object[0]);
        } else if (this.descriptionValue == null) {
            errorMsg = CodewindUIBundle.message("AddRepoDialogNoDescription", new Object[0]);
        }
        this.fireStateChanged(new ChangeEvent(component));
    }

    public void setDefaultValues(String[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void setNameValue(String name) {
        this.nameValue = name;
        this.nameTextField.setText(name);
    }

    public void setDescriptionValue(String description) {
        this.descriptionValue = description;
        this.descriptionTextField.setText(description);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.contentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = this.headerPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.mainContent = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.rowPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.nameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogNameLabel"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField = this.nameTextField;
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.descriptionLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogDescriptionLabel"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField2 = this.descriptionTextField;
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.rowButtonPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JButton jButton = this.resetButton;
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

