/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.codewind.filewatchers.core.FWAuthToken;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.internal.AuthTokenWrapper;
import org.json.JSONObject;

public class HttpUtil {
    private HttpUtil() {
    }

    private static String readAllFromStream(InputStream stream) {
        Scanner s = new Scanner(stream);
        s.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    private static void logError(String str) {
        FWLogger.getInstance().logError(str);
    }

    private static void log(String str) {
        if (FWLogger.getInstance().isDebug()) {
            System.out.println(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult get(URI uri, IHttpConnectionConfig conf, AuthTokenWrapper authTokenWrapper) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("GET");
            if (conf != null) {
                conf.setupConnection(connection);
            }
            FWAuthToken token = HttpUtil.addAuthIfApplicable(connection, authTokenWrapper);
            HttpResult result = new HttpResult(connection);
            HttpUtil.informBadTokenIfApplicable(result, token, authTokenWrapper);
            HttpResult httpResult = result;
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult put(URI uri, JSONObject payload, IHttpConnectionConfig conf, AuthTokenWrapper authTokenWrapper) throws IOException {
        HttpURLConnection connection = null;
        HttpUtil.log("PUT " + payload.toString() + " TO " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("PUT");
            if (conf != null) {
                conf.setupConnection(connection);
            }
            FWAuthToken token = HttpUtil.addAuthIfApplicable(connection, authTokenWrapper);
            if (payload != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                DataOutputStream payloadStream = new DataOutputStream(connection.getOutputStream());
                payloadStream.write(payload.toString().getBytes());
            }
            HttpResult result = new HttpResult(connection);
            HttpUtil.informBadTokenIfApplicable(result, token, authTokenWrapper);
            HttpResult httpResult = result;
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult post(URI uri, JSONObject payload, IHttpConnectionConfig conf, AuthTokenWrapper authTokenWrapper) throws IOException {
        HttpURLConnection connection = null;
        HttpUtil.log("POST " + payload.toString() + " TO " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("POST");
            FWAuthToken token = HttpUtil.addAuthIfApplicable(connection, authTokenWrapper);
            if (conf != null) {
                conf.setupConnection(connection);
            }
            if (payload != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                DataOutputStream payloadStream = new DataOutputStream(connection.getOutputStream());
                payloadStream.write(payload.toString().getBytes());
            }
            HttpResult result = new HttpResult(connection);
            HttpUtil.informBadTokenIfApplicable(result, token, authTokenWrapper);
            HttpResult httpResult = result;
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void allowAllCerts(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection huc = (HttpsURLConnection)connection;
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            huc.setHostnameVerifier(hostnameVerifier);
            try {
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                ctx.init(null, new TrustManager[]{tm}, new SecureRandom());
                huc.setSSLSocketFactory(ctx.getSocketFactory());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void informBadTokenIfApplicable(HttpResult result, FWAuthToken token, AuthTokenWrapper authTokenWrapper) {
        if (token == null || result == null) {
            return;
        }
        if (result.responseCode == 302 && result.headerFields != null && result.headerFields.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase("location")).flatMap(e -> ((List)e.getValue()).stream()).anyMatch(e -> e.contains("openid-connect/auth"))) {
            authTokenWrapper.informBadToken(token);
        }
    }

    private static FWAuthToken addAuthIfApplicable(HttpURLConnection connection, AuthTokenWrapper authTokenWrapper) {
        if (authTokenWrapper == null) {
            return null;
        }
        FWAuthToken token = authTokenWrapper.getLatestToken().orElse(null);
        if (token == null) {
            FWLogger.getInstance().logInfo("Requested a secure token from the IDE but got a null");
            return null;
        }
        connection.setInstanceFollowRedirects(false);
        connection.setRequestProperty("Authorization", token.getTokenType() + " " + token.getAccessToken());
        return token;
    }

    public static interface IHttpConnectionConfig {
        public void setupConnection(URLConnection var1);
    }

    public static class HttpResult {
        public final int responseCode;
        public final boolean isGoodResponse;
        public final String response;
        public final String error;
        private final Map<String, List<String>> headerFields;

        public HttpResult(HttpURLConnection connection) throws IOException {
            this.responseCode = connection.getResponseCode();
            this.isGoodResponse = this.responseCode > 199 && this.responseCode < 300;
            this.headerFields = connection != null && connection.getHeaderFields() != null ? connection.getHeaderFields() : null;
            InputStream eis = connection.getErrorStream();
            this.error = eis != null ? HttpUtil.readAllFromStream(eis) : null;
            if (!this.isGoodResponse) {
                HttpUtil.logError("Received bad response code " + this.responseCode + " from " + connection.getURL() + " - Error:\n" + this.error);
                this.response = null;
            } else {
                InputStream is = connection.getInputStream();
                this.response = is != null ? HttpUtil.readAllFromStream(is) : null;
            }
        }

        public String getHeader(String key) {
            if (this.headerFields == null) {
                return null;
            }
            List<String> list = this.headerFields.get(key);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }
}

