/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.wizard;

import org.eclipse.codewind.openapi.ui.Constants;
import org.eclipse.codewind.openapi.ui.Messages;
import org.eclipse.codewind.openapi.ui.wizard.AbstractGenerateWizardPage;
import org.eclipse.jface.viewers.ISelection;

public class GenerateServerWizardPage
extends AbstractGenerateWizardPage {
    public GenerateServerWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.SERVER_WIZARD_PAGE_TITLE);
        this.setDescription(Messages.SERVER_WIZARD_PAGE_DESCRIPTION);
        this.selection = selection;
    }

    @Override
    protected void populateGeneratorTypesCombo(String language) {
        this.generatorTypes.removeAll();
        for (int i = 0; i < Constants.ALL_SERVER_LANGUAGES.length; ++i) {
            if (!Constants.ALL_SERVER_LANGUAGES[i][0].equals(language)) continue;
            for (int j = 1; j < Constants.ALL_SERVER_LANGUAGES[i].length; ++j) {
                this.generatorTypes.add(Constants.ALL_SERVER_LANGUAGES[i][j]);
            }
            break;
        }
        if (language == "Java") {
            if (this.isCodewindProject && this.codewindProjectTypeId.equals(Constants.SPRING_PROJECT_TYPE_ID)) {
                if (this.generatorTypes.indexOf(Constants.SPRING_SERVER) >= 0) {
                    this.generatorTypes.remove(Constants.SPRING_SERVER);
                }
                this.generatorTypes.add(Constants.SPRING_SERVER, 0);
            }
            if (this.isCodewindProject && this.codewindProjectTypeId.equals(Constants.LIBERTY_PROJECT_TYPE_ID) || this.codewindProjectTypeId.equals(Constants.JAVA_DOCKER_PROJECT_TYPE_ID)) {
                int i;
                int length = Constants.LIBERTY_AND_DOCKER_SERVER_GENERATORS.length;
                for (i = 0; i < length; ++i) {
                    if (this.generatorTypes.indexOf(Constants.LIBERTY_AND_DOCKER_SERVER_GENERATORS[i]) < 0) continue;
                    this.generatorTypes.remove(Constants.LIBERTY_AND_DOCKER_SERVER_GENERATORS[i]);
                }
                for (i = length - 1; i >= 0; --i) {
                    this.generatorTypes.add(Constants.LIBERTY_AND_DOCKER_SERVER_GENERATORS[i], 0);
                }
            }
        }
        if (this.generatorTypes.getItemCount() > 0) {
            this.generatorTypes.select(0);
        }
    }

    @Override
    protected void fillLanguagesCombo() {
        this.languages.removeAll();
        for (int i = 0; i < Constants.ALL_SERVER_LANGUAGES.length; ++i) {
            this.languages.add(Constants.ALL_SERVER_LANGUAGES[i][0]);
        }
    }
}

