/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.core.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.codewind.openapi.core.Activator;
import org.eclipse.codewind.openapi.core.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class CommandRunner {
    private List<String> args_ = new ArrayList<String>();
    protected static String lineSeparator_;
    private String commandName;

    public CommandRunner(List<String> args, String commandName) {
        this.args_.addAll(args);
        lineSeparator_ = System.getProperty("line.separator");
        this.commandName = commandName;
    }

    public IStatus run() {
        ProcessBuilder pb = new ProcessBuilder(this.args_);
        pb.redirectErrorStream(true);
        StringBuffer outputBuffer = new StringBuffer();
        try {
            File javaHomePath = CommandRunner.getJavaHome();
            boolean argsAdded = false;
            if (javaHomePath != null) {
                Map<String, String> environment = pb.environment();
                environment.put("JAVA_HOME", javaHomePath.getPath());
                File javaExecutablePath = CommandRunner.getJavaBinaryPath(javaHomePath);
                if (javaExecutablePath != null && javaExecutablePath.exists()) {
                    File javaBinDirectory = javaExecutablePath.getParentFile();
                    Set<String> keySet = environment.keySet();
                    if (keySet.contains("PATH")) {
                        environment.put("PATH", javaBinDirectory.getPath() + File.pathSeparator + environment.get("PATH"));
                    } else if (keySet.contains("Path")) {
                        environment.put("Path", javaBinDirectory.getPath() + File.pathSeparator + environment.get("Path"));
                    } else {
                        environment.put("PATH", javaBinDirectory.getPath());
                    }
                    this.args_.add(0, javaExecutablePath.getPath());
                    argsAdded = true;
                }
            }
            if (!argsAdded) {
                this.args_.add(0, "java");
            }
            Process process = pb.start();
            CommandOutputReader reader = new CommandOutputReader(process.getInputStream(), outputBuffer);
            reader.start();
            int rc = process.waitFor();
            Activator.log(1, "Codegen result:");
            Activator.log(1, "RC = " + rc + "\n" + outputBuffer.toString());
            if (rc != 0) {
                String[] lines;
                outputBuffer.insert(0, lineSeparator_);
                String outputBufferText = outputBuffer.toString();
                String pluginId = Activator.getDefault().getBundle().getSymbolicName();
                MultiStatus multiStatus = new MultiStatus(pluginId, 4, MessageFormat.format(Messages.COMMAND_RUNNER_ERROR, this.commandName), null);
                String consoleOutputNew = outputBufferText.replace("\r", "");
                for (String line : lines = consoleOutputNew.split("\n")) {
                    multiStatus.add((IStatus)new Status(4, pluginId, line));
                }
                return multiStatus;
            }
        }
        catch (InterruptedException e) {
            return this.createErrorStatus(outputBuffer, e);
        }
        catch (IOException e) {
            return this.createErrorStatus(outputBuffer, e);
        }
        return Status.OK_STATUS;
    }

    private final IStatus createErrorStatus(StringBuffer outputBuffer, Throwable throwable) {
        outputBuffer.insert(0, lineSeparator_);
        outputBuffer.insert(0, MessageFormat.format(Messages.COMMAND_RUNNER_ERROR, this.commandName));
        if (throwable == null) {
            return new Status(4, "org.eclipse.codewind.openapi.core", outputBuffer.toString());
        }
        return new Status(4, "org.eclipse.codewind.openapi.core", outputBuffer.toString(), throwable);
    }

    private static File getJavaHome() {
        File result = null;
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null && install.getInstallLocation() != null && install.getInstallLocation().exists()) {
            result = install.getInstallLocation();
        }
        return result;
    }

    private static File getJavaBinaryPath(File homeDir) {
        File result = null;
        if (homeDir != null && homeDir.exists()) {
            boolean isWindows;
            String osName = System.getProperty("os.name").toLowerCase();
            boolean bl = isWindows = osName.indexOf("win") >= 0;
            if (isWindows) {
                File java = new File(homeDir, "bin\\java.exe");
                if (java.exists()) {
                    result = java;
                } else {
                    java = new File(homeDir, "jre\\bin\\java.exe");
                    if (java.exists()) {
                        result = java;
                    }
                }
            } else {
                File java = new File(homeDir, "bin/java");
                if (java.exists()) {
                    result = java;
                } else {
                    java = new File(homeDir, "jre/bin/java");
                    if (java.exists()) {
                        result = java;
                    }
                }
            }
        }
        return result;
    }

    final class CommandOutputReader
    extends Thread {
        private InputStream is;
        private StringBuffer sb;

        public CommandOutputReader(InputStream is, StringBuffer sb) {
            this.is = is;
            this.sb = sb;
        }

        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
            try {
                String s;
                while ((s = br.readLine()) != null) {
                    this.sb.append(s).append(lineSeparator_);
                }
            }
            catch (IOException e) {
                return;
            }
        }
    }
}

