/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.commands;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.codewind.openapi.core.commands.CommandRunner;
import org.eclipse.codewind.openapi.ui.Activator;
import org.eclipse.codewind.openapi.ui.commands.AbstractOpenApiGeneratorCommand;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class GenerateServerCommand
extends AbstractOpenApiGeneratorCommand {
    public GenerateServerCommand() {
    }

    public GenerateServerCommand(ISchedulingRule rule) {
        super(rule);
    }

    @Override
    protected CommandRunner getCommandRunner(List<String> mainArgsList) {
        return new CommandRunner(mainArgsList, "ServerGenerator");
    }

    @Override
    protected void populateArgsList(List<String> mainArgsList) {
        mainArgsList.add("-jar");
        mainArgsList.add(this.codegenJar);
        mainArgsList.add("generate");
        mainArgsList.add("-g");
        mainArgsList.add(this.generatorType);
        boolean isLiberty = false;
        boolean isAppsodyLiberty = false;
        IResource serverProjectFile = this.project.findMember("/src/main/liberty/config/server.xml");
        if (serverProjectFile != null) {
            isLiberty = serverProjectFile.exists();
            IResource appsodyProjectFile = this.project.findMember(".appsody-config.yaml");
            if (appsodyProjectFile != null) {
                boolean bl = isAppsodyLiberty = isLiberty && appsodyProjectFile.exists();
            }
        }
        if (this.generatorType.equals("jaxrs-spec") && this.codewindProjectTypeId != null && this.codewindProjectTypeId.toLowerCase().indexOf("liberty") >= 0 || this.codewindProjectTypeId != null && this.codewindProjectTypeId.toLowerCase().indexOf("docker") >= 0 && isLiberty || this.codewindProjectTypeId != null && this.codewindProjectTypeId.toLowerCase().indexOf("appsodyextension") >= 0 && isAppsodyLiberty) {
            mainArgsList.add("--library");
            mainArgsList.add("openliberty");
            mainArgsList.add("--enable-post-process-file");
        }
        mainArgsList.add("-i");
        if (this.openApiFile != null) {
            mainArgsList.add(this.argSurround + this.openApiFile.getLocation().toOSString() + this.argSurround);
        }
        mainArgsList.add("-o");
        if (this.outputFolder.getLocation() != null) {
            mainArgsList.add(this.argSurround + this.outputFolder.getLocation().toOSString() + this.argSurround);
        } else {
            mainArgsList.add(this.argSurround + this.outputFolder.getFullPath().toOSString() + this.argSurround);
        }
        if (this.generatorType.equals("spring")) {
            try {
                mainArgsList.add("-t");
                URL resource = org.eclipse.codewind.openapi.core.Activator.getDefault().getBundle().getEntry("templates/JavaSpring401");
                URL fileURL = FileLocator.toFileURL((URL)resource);
                String path = fileURL.getFile();
                if (this.isWindows && path != null && path.startsWith("/")) {
                    path = path.substring(1);
                }
                mainArgsList.add(this.argSurround + path + this.argSurround);
                if (this.pomFileExists) {
                    mainArgsList.add("--additional-properties");
                    mainArgsList.add("mavenPomExists=true");
                }
            }
            catch (IOException e) {
                Activator.log(4, e);
            }
        }
        Activator.log(1, mainArgsList.toString());
    }
}

