/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.core.contenttype;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.codewind.openapi.core.contenttype.IOpenApiContentDetector;

public abstract class OpenApiContentDetector
implements IOpenApiContentDetector {
    protected boolean fOpenApiFieldDetected = false;
    protected boolean fOpenApiParsed;
    protected Reader fReader;

    @Override
    public boolean isOpenApiDetected() {
        if (!this.fOpenApiParsed) {
            try {
                this.parseInput();
            }
            catch (IOException e) {
                this.fOpenApiFieldDetected = false;
            }
            finally {
                try {
                    this.fReader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this.fOpenApiParsed = true;
        }
        return this.fOpenApiFieldDetected;
    }

    @Override
    public void set(InputStream inputStream) {
        this.resetAll();
        this.fReader = new InputStreamReader(inputStream);
    }

    @Override
    public void set(Reader reader) {
        this.resetAll();
        this.fReader = reader;
        if (!this.fReader.markSupported()) {
            this.fReader = new BufferedReader(this.fReader);
        }
    }

    protected void resetAll() {
        this.fReader = null;
        this.fOpenApiParsed = false;
    }

    protected abstract void parseInput() throws IOException;

    protected boolean findString(String ... target) {
        boolean analyze = true;
        int i = 1;
        char[] c = new char[1];
        String firstNonSpaceChar = "";
        int numberOfTargets = target.length;
        try {
            boolean moreSpaces = true;
            do {
                int aChar;
                if ((aChar = this.fReader.read(c)) < 1) {
                    analyze = false;
                }
                if ((firstNonSpaceChar = String.valueOf(c)).trim().length() <= 0) continue;
                moreSpaces = false;
            } while (analyze && moreSpaces && ++i < 80);
            if (moreSpaces) {
                return false;
            }
            analyze = true;
            String text = firstNonSpaceChar;
            do {
                int read;
                if ((read = this.fReader.read(c)) < 1) {
                    analyze = false;
                }
                text = text + String.valueOf(c);
                boolean startsWithMatch = false;
                for (int j = 0; j < numberOfTargets; ++j) {
                    if (!target[j].startsWith(text.trim())) continue;
                    startsWithMatch = true;
                    if (!target[j].equals(text.trim())) continue;
                    return true;
                }
                if (startsWithMatch) continue;
                analyze = false;
            } while (analyze);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean findChar(char target) {
        int i = 1;
        char[] possibleLeadingSpace = new char[1];
        String firstNonSpaceChar = "";
        try {
            boolean moreSpaces = true;
            do {
                int aChar;
                if ((aChar = this.fReader.read(possibleLeadingSpace)) < 1) {
                    return false;
                }
                firstNonSpaceChar = String.valueOf(possibleLeadingSpace);
                if (firstNonSpaceChar.trim().length() <= 0) continue;
                moreSpaces = false;
            } while (moreSpaces && ++i < 80);
            if (moreSpaces) {
                return false;
            }
            if (target == firstNonSpaceChar.charAt(0)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

