/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.core.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.codewind.openapi.core.contenttype.IOpenApiContentDetector;
import org.eclipse.codewind.openapi.core.contenttype.OpenApiContentDetector;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public abstract class OpenApiContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};

    public abstract IOpenApiContentDetector getDetector();

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        int result = 0;
        result = this.determineValidity(result, contents);
        return result;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        int result = 0;
        result = this.determineValidity(result, contents);
        return result;
    }

    private int determineValidity(int result, InputStream contents) throws IOException {
        int returnResult = result;
        IOpenApiContentDetector detector = this.getDetector();
        contents.reset();
        detector.set(contents);
        returnResult = this.determineValidity(detector, returnResult);
        return returnResult;
    }

    private int determineValidity(int result, Reader contents) throws IOException {
        int returnResult = result;
        IOpenApiContentDetector detector = this.getDetector();
        contents.reset();
        detector.set(contents);
        returnResult = this.determineValidity(detector, returnResult);
        return returnResult;
    }

    private int determineValidity(IOpenApiContentDetector detector, int returnResult) {
        if (detector instanceof OpenApiContentDetector) {
            OpenApiContentDetector openApiDetector = (OpenApiContentDetector)detector;
            returnResult = openApiDetector.isOpenApiDetected() ? 2 : 0;
        }
        return returnResult;
    }
}

