/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.core.maven;

import org.eclipse.codewind.openapi.core.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;

public class Utils {
    public static boolean isMavenProject(IProject project) throws CoreException {
        try {
            return project.hasNature("org.eclipse.m2e.core.maven2Nature");
        }
        catch (CoreException e) {
            Activator.log(1, "Error when checking for Maven project nature");
            throw e;
        }
    }

    public static boolean hasJavaNature(IProject project) throws CoreException {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            Activator.log(1, "Error when checking for Maven project nature");
            throw e;
        }
    }

    public static void updateProject(IProject[] projects, boolean doSchedule, IProgressMonitor monitor) {
        if (!doSchedule) {
            new UpdateMavenProjectJob(projects).run(monitor);
        } else {
            new UpdateMavenProjectJob(projects).schedule();
        }
    }

    public static boolean isSupportedMavenProject(IProject project) {
        try {
            if (!Utils.isMavenProject(project)) {
                return false;
            }
            IFile pom = project.getFile("pom.xml");
            if (pom == null || !pom.exists()) {
                Activator.log(1, "Project has Maven nature but the pom.xml file does not exist");
                return false;
            }
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }
}

