/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import java.util.List;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class ViewHelper {
    public static void openCodewindExplorerView() {
        ViewHelper.openNavigatorView("org.eclipse.codewind.ui.explorerView");
    }

    public static void refreshCodewindExplorerView(Object element) {
        Object obj = element == null ? CodewindManager.getManager() : element;
        ViewHelper.refreshNavigatorView("org.eclipse.codewind.ui.explorerView", obj);
    }

    public static void expandConnection(final CodewindConnection connection) {
        if (connection == null) {
            return;
        }
        List apps = connection.getApps();
        if (!apps.isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CommonViewer viewer;
                    IViewPart view = ViewHelper.getViewPart("org.eclipse.codewind.ui.explorerView");
                    if (view instanceof CommonNavigator && !(viewer = ((CommonNavigator)view).getCommonViewer()).getExpandedState((Object)connection)) {
                        viewer.expandToLevel(-1);
                    }
                }
            });
        }
    }

    public static void toggleExpansion(Object element) {
        final Object obj = element == null ? CodewindManager.getManager() : element;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart view = ViewHelper.getViewPart("org.eclipse.codewind.ui.explorerView");
                if (view instanceof CommonNavigator) {
                    CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
                    if (!viewer.getExpandedState(obj)) {
                        viewer.expandToLevel(obj, -1);
                    } else {
                        viewer.collapseToLevel(obj, -1);
                    }
                }
            }
        });
    }

    public static void openNavigatorView(final String viewId) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart part;
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null && (part = page.findView(viewId)) == null) {
                    try {
                        part = page.showView(viewId);
                    }
                    catch (PartInitException e) {
                        Logger.logError((String)("An error occurred when trying to open the navigator view: " + viewId), (Throwable)e);
                    }
                }
            }
        });
    }

    public static void refreshNavigatorView(final String viewId, final Object element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart part = ViewHelper.getViewPart(viewId);
                if (part != null && part instanceof CommonNavigator) {
                    CommonNavigator v = (CommonNavigator)part;
                    v.getCommonViewer().refresh(element);
                    v.getCommonViewer().expandToLevel(element, -1);
                }
            }
        });
    }

    public static IViewPart getViewPart(String viewId) {
        for (IWorkbenchWindow window : PlatformUI.getWorkbench().getWorkbenchWindows()) {
            for (IWorkbenchPage page : window.getPages()) {
                for (IViewReference reference : page.getViewReferences()) {
                    if (!viewId.equals(reference.getId())) continue;
                    return reference.getView(false);
                }
            }
        }
        return null;
    }
}

