/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;

public class Logger
implements DebugOptionsListener {
    private static final ILog logger = CodewindCorePlugin.getDefault().getLog();
    private static Logger instance;
    private static boolean logInfo;
    private static final String INFO_LEVEL = "/debug/info";

    private Logger() {
        instance = this;
    }

    public static Logger instance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public void optionsChanged(DebugOptions debugOptions) {
        logInfo = debugOptions.getBooleanOption("org.eclipse.codewind.core/debug/info", false);
    }

    public static void log(String msg) {
        Logger.writeLog(msg, false, null);
    }

    public static void logError(String msg) {
        Logger.writeLog(msg, true, null);
    }

    public static void logError(Throwable t) {
        Logger.logError("Exception occurred:", t);
    }

    public static void logError(String msg, Throwable t) {
        Logger.writeLog(msg, true, t);
    }

    private static void writeLog(String msg, boolean isError, Throwable t) {
        if (!isError && !logInfo) {
            return;
        }
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        StackTraceElement callingMethod = null;
        for (int x = 0; x < ste.length; ++x) {
            if (!ste[x].getMethodName().equals("writeLog")) continue;
            callingMethod = ste[x++];
            while (callingMethod.getMethodName().equals("writeLog") || callingMethod.getMethodName().equals("log") || callingMethod.getMethodName().equals("logError")) {
                callingMethod = ste[x++];
            }
            break;
        }
        String callerInfo = "unknown";
        if (callingMethod != null) {
            String className = callingMethod.getClassName();
            String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
            callerInfo = String.format("%s.%s:%s", simpleClassName, callingMethod.getMethodName(), callingMethod.getLineNumber());
        }
        String type = isError ? "ERROR" : "INFO";
        String fullMessage = String.format("[%s %s] %s", type, callerInfo, msg);
        int level = isError ? 4 : 1;
        Status status = t != null ? new Status(level, "org.eclipse.codewind.core", fullMessage, t) : new Status(level, "org.eclipse.codewind.core", fullMessage);
        logger.log((IStatus)status);
    }
}

