/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.net.URL;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.JSONObjectResult;
import org.json.JSONObject;

public class ConnectionEnv
extends JSONObjectResult {
    public static final String KEY_VERSION = "codewind_version";
    public static final String UNKNOWN_VERSION = "unknown";
    public static final String KEY_SOCKET_NAMESPACE = "socket_namespace";
    public static final String KEY_TEKTON_DASHBOARD = "tekton_dashboard";
    private TektonDashboard tektonDashboard;

    public ConnectionEnv(JSONObject env) {
        super(env, "connection environment");
    }

    public String getVersion() {
        String version = this.getString(KEY_VERSION);
        if (version == null) {
            version = UNKNOWN_VERSION;
        }
        return version;
    }

    public String getSocketNamespace() {
        return this.getString(KEY_SOCKET_NAMESPACE);
    }

    public TektonDashboard getTektonDashboard() {
        if (this.tektonDashboard == null) {
            JSONObject jsonObject = this.getObject(KEY_TEKTON_DASHBOARD);
            this.tektonDashboard = new TektonDashboard(jsonObject);
        }
        return this.tektonDashboard;
    }

    public class TektonDashboard
    extends JSONObjectResult {
        public static final String KEY_TEKTON_DASHBOARD_STATUS = "status";
        public static final String KEY_TEKTON_DASHBOARD_MESSAGE = "message";
        public static final String KEY_TEKTON_DASHBOARD_URL = "url";
        public static final String NOT_INSTALLED_MSG = "not-installed";

        protected TektonDashboard(JSONObject tektonDashboard) {
            super(tektonDashboard, "tekton dashboard");
        }

        public boolean hasTektonDashboard() {
            return this.getBoolean(KEY_TEKTON_DASHBOARD_STATUS);
        }

        public boolean isNotInstalled() {
            return NOT_INSTALLED_MSG.equals(this.getTektonMessage());
        }

        public String getTektonMessage() {
            return this.getString(KEY_TEKTON_DASHBOARD_MESSAGE);
        }

        public URL getTektonUrl() {
            String urlStr = this.getString(KEY_TEKTON_DASHBOARD_URL);
            if (urlStr == null || urlStr.isEmpty()) {
                return null;
            }
            try {
                return new URL("http://" + urlStr);
            }
            catch (Exception e) {
                Logger.logError("The Tekton dashboard URL is not valid: " + urlStr, e);
                return null;
            }
        }
    }
}

