/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.connection.RepositoryInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONArray;
import org.json.JSONException;

public class TemplateUtil {
    private static final String TEMPLATES_CMD = "templates";
    private static final String LIST_OPTION = "list";
    private static final String REPOS_OPTION = "repos";
    private static final String[] LIST_CMD = new String[]{"templates", "list"};
    private static final String[] REPO_LIST_CMD = new String[]{"templates", "repos", "list"};
    private static final String[] REPO_ADD_CMD = new String[]{"templates", "repos", "add"};
    private static final String[] REPO_REMOVE_CMD = new String[]{"templates", "repos", "remove"};
    private static final String[] REPO_ENABLE_CMD = new String[]{"templates", "repos", "enable"};
    private static final String[] REPO_DISABLE_CMD = new String[]{"templates", "repos", "disable"};
    private static final String ENABLED_ONLY_OPTION = "--showEnabledOnly";
    private static final String URL_OPTION = "--url";
    private static final String NAME_OPTION = "--name";
    private static final String DESCRIPTION_OPTION = "--description";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProjectTemplateInfo> listTemplates(boolean enabledOnly, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        String[] stringArray;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Process process = null;
        if (enabledOnly) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = ENABLED_ONLY_OPTION;
            stringArray2[1] = "--conid";
            stringArray = stringArray2;
            stringArray2[2] = conid;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "--conid";
            stringArray = stringArray3;
            stringArray3[1] = conid;
        }
        String[] options = stringArray;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_INSECURE, LIST_CMD, options);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("List templates failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("List templates had 0 return code but the output is empty");
                throw new IOException("The output from list templates is empty.");
            }
            JSONArray templateArray = new JSONArray(result.getOutput().trim());
            ArrayList<ProjectTemplateInfo> templates = new ArrayList<ProjectTemplateInfo>();
            for (int i = 0; i < templateArray.length(); ++i) {
                templates.add(new ProjectTemplateInfo(templateArray.getJSONObject(i)));
            }
            ArrayList<ProjectTemplateInfo> arrayList = templates;
            return arrayList;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RepositoryInfo> listTemplateSources(String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_INSECURE, REPO_LIST_CMD, new String[]{"--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("List templates sources failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("List template sources had 0 return code but the output is empty");
                throw new IOException("The output from list template sources is empty.");
            }
            JSONArray repoArray = new JSONArray(result.getOutput());
            ArrayList<RepositoryInfo> repos = new ArrayList<RepositoryInfo>();
            for (int i = 0; i < repoArray.length(); ++i) {
                repos.add(new RepositoryInfo(repoArray.getJSONObject(i)));
            }
            ArrayList<RepositoryInfo> arrayList = repos;
            return arrayList;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static void addTemplateSource(String url, String name, String description, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        TemplateUtil.runTemplateSourceCmd(REPO_ADD_CMD, new String[]{URL_OPTION, url, NAME_OPTION, name, DESCRIPTION_OPTION, description, "--conid", conid}, null, monitor);
    }

    public static void removeTemplateSource(String url, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        TemplateUtil.runTemplateSourceCmd(REPO_REMOVE_CMD, new String[]{URL_OPTION, url, "--conid", conid}, null, monitor);
    }

    public static void enableTemplateSource(boolean enable, String url, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        String[] cmd = enable ? REPO_ENABLE_CMD : REPO_DISABLE_CMD;
        TemplateUtil.runTemplateSourceCmd(cmd, new String[]{"--conid", conid}, new String[]{url}, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTemplateSourceCmd(String[] command, String[] options, String[] args, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_INSECURE, command, options, args);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("The " + Arrays.toString(command) + " command with options " + Arrays.toString(options) + " failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

