/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CoreUtil {
    private static final String ENV_PATH_PROPERTY = "org.eclipse.codewind.envPath";

    public static void openDialog(boolean isError, final String title, final String msg) {
        final int kind = isError ? 1 : 2;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.open((int)kind, (Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg, (int)0);
            }
        });
    }

    public static boolean openConfirmDialog(final String title, final String msg) {
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.open((int)5, (Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg, (int)0);
            }
        });
        return result[0];
    }

    public static String readAllFromStream(InputStream stream) {
        Scanner s = new Scanner(stream);
        s.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    public static String getHostPath(String containerPath) {
        String hostPath = containerPath;
        if (CoreUtil.isWindows() && containerPath.startsWith("/")) {
            String device = containerPath.substring(1, 2);
            hostPath = device + ":" + containerPath.substring(2);
        }
        return hostPath;
    }

    public static String getContainerPath(String hostPath) {
        String containerPath = hostPath;
        if (CoreUtil.isWindows() && hostPath.indexOf(58) == 1) {
            containerPath = "/" + hostPath.charAt(0) + hostPath.substring(2);
            containerPath = containerPath.replace("\\", "/");
        }
        return containerPath;
    }

    public static IPath appendPathWithoutDupe(IPath start, String finish) {
        Path finishPath = new Path(finish);
        if (start.lastSegment().equals(finishPath.segment(0))) {
            start = start.removeLastSegments(1);
        }
        return start.append((IPath)finishPath);
    }

    public static List<String> splitPath(IPath path, int length) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentString = new StringBuilder().append('/');
        for (String segment : path.segments()) {
            if (currentString.length() + segment.length() > length) {
                result.add(currentString.toString());
                currentString = new StringBuilder();
            }
            currentString.append(segment).append('/');
        }
        if (currentString.length() > 0) {
            result.add(currentString.toString());
        }
        return result;
    }

    public static String toCommaSeparatedString(Collection<String> collection) {
        StringBuilder resultBuilder = new StringBuilder();
        String separator = ", ";
        for (String s : collection) {
            resultBuilder.append(s).append(", ");
        }
        if (resultBuilder.length() > ", ".length()) {
            resultBuilder.setLength(resultBuilder.length() - ", ".length());
        }
        return resultBuilder.toString();
    }

    public static int parsePort(String portStr) {
        try {
            return Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            Logger.logError(String.format("Couldn't parse port from \"%s\"", portStr), e);
            return -1;
        }
    }

    public static void updateAll() {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.updateAll();
        }
    }

    public static void updateConnection(CodewindConnection connection) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.updateConnection(connection);
        }
    }

    public static void removeConnection(List<CodewindApplication> apps) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.removeConnection(apps);
        }
    }

    public static void updateApplication(CodewindApplication app) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.updateApplication(app);
        }
    }

    public static void removeApplication(CodewindApplication app) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.removeApplication(app);
        }
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static boolean isMACOS() {
        String osName = CoreUtil.getOSName();
        return osName != null && osName.toLowerCase().contains("mac");
    }

    public static String getEnvPath() {
        String path = System.getProperty(ENV_PATH_PROPERTY);
        if (path == null || path.trim().isEmpty()) {
            if (CoreUtil.isMACOS()) {
                return "/usr/local/bin/";
            }
            return null;
        }
        path = path.trim();
        if (!(path = path.replace("\\", "/")).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }
}

