/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.net.URL;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.JSONObjectResult;
import org.json.JSONObject;

public class ConnectionEnv
extends JSONObjectResult {
    public static final String KEY_VERSION = "codewind_version";
    public static final String UNKNOWN_VERSION = "unknown";
    public static final String KEY_SOCKET_NAMESPACE = "socket_namespace";
    public static final String KEY_TEKTON_DASHBOARD_URL = "tekton_dashboard_url";
    public static final String VALUE_TEKTON_DASHBOARD_NOT_INSTALLED = "not-installed";
    public static final String VALUE_TEKTON_DASHBOARD_ERROR = "error";

    public ConnectionEnv(JSONObject env) {
        super(env, "connection environment");
    }

    public String getVersion() {
        String version = this.getString(KEY_VERSION);
        if (version == null) {
            version = UNKNOWN_VERSION;
        }
        return version;
    }

    public String getSocketNamespace() {
        return this.getString(KEY_SOCKET_NAMESPACE);
    }

    public URL getTektonDashboardURL() {
        String urlStr = this.getString(KEY_TEKTON_DASHBOARD_URL);
        if (urlStr == null || urlStr.isEmpty() || urlStr.equals(VALUE_TEKTON_DASHBOARD_NOT_INSTALLED) || urlStr.equals(VALUE_TEKTON_DASHBOARD_ERROR)) {
            return null;
        }
        try {
            return new URL(urlStr);
        }
        catch (Exception e) {
            Logger.logError("The Tekton dashboard URL is not valid: " + urlStr, e);
            return null;
        }
    }
}

