/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import * as we from "./WatchEventEntry";
/**
 * Simple representation of a single change: the file/dir path that changed,
 * what type of change, and when. These are then consumed by the batch
 * processing utility.
 */
export declare class ChangedFileEntry {
    private readonly _eventType;
    private readonly _timestamp;
    private readonly _path;
    private readonly _directory;
    constructor(path: string, type: we.EventType, timestamp: number, directory: boolean);
    toJson(): IChangedFileEntryJson;
    readonly timestamp: number;
    readonly eventType: we.EventType;
    readonly path: string;
    readonly directory: boolean;
}
/** Represents a single file change that is then communicated and sent in the HTTP POST request. */
export interface IChangedFileEntryJson {
    path: string;
    timestamp: number;
    type: string;
    directory: boolean;
}
