/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.cli;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.JSONObjectResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectionInfo
extends JSONObjectResult {
    private static final String SCHEMAVERSION_KEY = "schemaversion";
    private static final String CONNECTIONS_KEY = "connections";
    private static final String ID_KEY = "id";
    private static final String LABEL_KEY = "label";
    private static final String URL_KEY = "url";
    private static final String AUTH_KEY = "auth";
    private static final String REALM_KEY = "realm";
    private static final String CLIENTID_KEY = "clientid";
    private static final String USERNAME_KEY = "username";

    public ConnectionInfo(JSONObject connectionInfo) {
        super(connectionInfo, "connection info");
    }

    public String getId() {
        return this.getString(ID_KEY);
    }

    public boolean isLocal() {
        return "local".equals(this.getId());
    }

    public String getLabel() {
        return this.getString(LABEL_KEY);
    }

    public String getURL() {
        return this.getString(URL_KEY);
    }

    public String getAuth() {
        return this.getString(AUTH_KEY);
    }

    public String getRealm() {
        return this.getString(REALM_KEY);
    }

    public String getClientid() {
        return this.getString(CLIENTID_KEY);
    }

    public String getUsername() {
        return this.getString(USERNAME_KEY);
    }

    public static List<ConnectionInfo> getInfos(JSONObject connectionsObj) {
        ArrayList<ConnectionInfo> connections = new ArrayList<ConnectionInfo>();
        try {
            if (connectionsObj.has(SCHEMAVERSION_KEY) && connectionsObj.getInt(SCHEMAVERSION_KEY) == 1 && connectionsObj.has(CONNECTIONS_KEY)) {
                JSONArray array = connectionsObj.getJSONArray(CONNECTIONS_KEY);
                for (int i = 0; i < array.length(); ++i) {
                    connections.add(new ConnectionInfo(array.getJSONObject(i)));
                }
            }
        }
        catch (JSONException e) {
            Logger.logWarning("The output for the connection list is not valid", e);
        }
        return connections;
    }
}

