/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.eclipse.codewind.intellij.core.connection.ProjectTemplateInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;

public class TemplateTableModel
extends AbstractTableModel {
    private static String[] COLUMN_NAMES = new String[]{CodewindUIBundle.message("NewProjectPage_TemplateColumn", new Object[0]), CodewindUIBundle.message("NewProjectPage_TypeColumn", new Object[0]), CodewindUIBundle.message("NewProjectPage_LanguageColumn", new Object[0])};
    private ProjectTemplateInfo[] templates = new ProjectTemplateInfo[0];

    public void update(List<ProjectTemplateInfo> templates) {
        this.templates = templates.toArray(new ProjectTemplateInfo[0]);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.templates.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.templates[row].getLabel();
            }
            case 1: {
                return ProjectType.getDisplayName(this.templates[row].getProjectType());
            }
            case 2: {
                return ProjectLanguage.getDisplayName(this.templates[row].getLanguage());
            }
        }
        throw new IllegalStateException("Unexpected value: " + column);
    }

    public ProjectTemplateInfo getTemplateAt(int row) {
        return this.templates[row];
    }
}

