/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.tabs.TabbedContentAction;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.JComponent;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.console.ProjectLogInfo;
import org.eclipse.codewind.intellij.core.console.SocketConsole;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;
import org.eclipse.codewind.intellij.ui.CodewindToolWindow;
import org.eclipse.codewind.intellij.ui.IconCache;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.toolwindow.UpdateHandler;
import org.eclipse.codewind.intellij.ui.tree.CodewindToolWindowHelper;
import org.jetbrains.annotations.NotNull;

public class ShowAllLogFilesTask
extends Task.Backgroundable {
    private final CodewindApplication application;
    private ToolWindow logFilesToolWindow;
    private ContentManager contentManager = null;

    public ShowAllLogFilesTask(CodewindApplication application, Project project) {
        super(project, CodewindUIBundle.message("ShowAllLogFilesAction", new Object[0]));
        this.application = application;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ShowAllLogFilesTask.$$$reportNull$$$0(0);
        }
        CoreUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowAllLogFilesTask.this.initToolWindow();
                List<ProjectLogInfo> logInfos = ShowAllLogFilesTask.this.application.getLogInfos();
                ProjectLogInfo firstAppLog = logInfos.size() > 0 ? logInfos.get(0) : null;
                for (ProjectLogInfo logInfo : logInfos) {
                    Content content = ShowAllLogFilesTask.this.getContentForProjectLogInfo(logInfo);
                    SocketConsole socketConsole = null;
                    if (content == null) {
                        socketConsole = ShowAllLogFilesTask.this.createLogFileToolWindow(logInfo);
                    }
                    try {
                        if (socketConsole == null) continue;
                        socketConsole.initialize();
                    }
                    catch (Exception e) {
                        Logger.log(e);
                    }
                }
                if (!ShowAllLogFilesTask.this.logFilesToolWindow.isVisible() && ShowAllLogFilesTask.this.logFilesToolWindow.isAvailable()) {
                    ShowAllLogFilesTask.this.logFilesToolWindow.show(null);
                    ShowAllLogFilesTask.this.logFilesToolWindow.activate(null, true, true);
                }
                if (firstAppLog != null) {
                    Content firstContent = ShowAllLogFilesTask.this.getContentForProjectLogInfo(firstAppLog);
                    ShowAllLogFilesTask.this.logFilesToolWindow.getContentManager().setSelectedContent(firstContent);
                }
            }
        });
    }

    private void initToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.getProject());
        this.logFilesToolWindow = toolWindowManager.getToolWindow(CodewindToolWindowHelper.SHOW_LOG_FILES_TOOLWINDOW_ID);
        boolean windowRequiresRegistration = false;
        if (this.logFilesToolWindow == null) {
            windowRequiresRegistration = true;
            this.logFilesToolWindow = toolWindowManager.registerToolWindow(CodewindToolWindowHelper.SHOW_LOG_FILES_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM);
            this.logFilesToolWindow.setContentUiType(ToolWindowContentUiType.COMBO, null);
            this.logFilesToolWindow.setIcon(IconCache.getCachedIcon("/META-INF/pluginIcon13x13.svg"));
        }
        this.contentManager = this.logFilesToolWindow.getContentManager();
        if (windowRequiresRegistration) {
            this.contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    ContentManagerEvent.ContentOperation operation;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((operation = event.getOperation()).equals((Object)ContentManagerEvent.ContentOperation.remove)) {
                        String connectionId = ((ShowAllLogFilesTask)ShowAllLogFilesTask.this).application.connection.getConid();
                        String projectId = ((ShowAllLogFilesTask)ShowAllLogFilesTask.this).application.projectID;
                        if (connectionId != null && projectId != null) {
                            CodewindToolWindow.getToolWindowUpdateHandler().removeAppUpdateListener(event.getContent(), connectionId, projectId);
                        }
                        Key<SocketConsole> key = CodewindToolWindow.getLogsKeyMap().get(event.getContent());
                        final SocketConsole sc = (SocketConsole)ShowAllLogFilesTask.this.getProject().getUserData(key);
                        CoreUtil.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (sc != null) {
                                    sc.dispose();
                                }
                            }
                        });
                    }
                }

                public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "org/eclipse/codewind/intellij/ui/tasks/ShowAllLogFilesTask$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contentRemoved";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contentRemoveQuery";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private Content getContentForProjectLogInfo(ProjectLogInfo logInfo) {
        Content content = this.contentManager.findContent(CodewindCoreBundle.message("LogFileConsoleName", this.application.name, logInfo.logName));
        return content;
    }

    private SocketConsole createLogFileToolWindow(final ProjectLogInfo logInfo) {
        Content content = null;
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject()).getConsole();
        SimpleToolWindowPanel simplePanel = new SimpleToolWindowPanel(false, true);
        content = ContentFactory.SERVICE.getInstance().createContent((JComponent)simplePanel, CodewindCoreBundle.message("LogFileConsoleName", this.application.name, logInfo.logName), true);
        simplePanel.setContent(consoleView.getComponent());
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.setIcon(IconCache.getCachedIcon("/META-INF/pluginIcon13x13.svg"));
        content.setDescription(CodewindCoreBundle.message("LogFileConsoleName", this.application.name, logInfo.logName));
        this.contentManager.addContent(content);
        Disposer.register((Disposable)this.getProject(), (Disposable)consoleView);
        final SocketConsole socketConsole = new SocketConsole(content, consoleView, content.getDisplayName(), logInfo, this.application);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        AnAction[] consoleActions = consoleView.createConsoleActions();
        for (int i = 0; i < consoleActions.length; ++i) {
            if (consoleActions[i] instanceof PreviousOccurenceToolbarAction || consoleActions[i] instanceof NextOccurenceToolbarAction) continue;
            toolbarGroup.add(consoleActions[i]);
        }
        AnAction helpAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    BrowserLauncher.getInstance().browse(new URI("https://www.eclipse.org/codewind/intellij-getting-started.html"));
                }
                catch (URISyntaxException ex) {
                    Logger.log(ex);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/tasks/ShowAllLogFilesTask$3", "actionPerformed"));
            }
        };
        helpAction.getTemplatePresentation().setIcon(AllIcons.Actions.Help);
        toolbarGroup.add(helpAction);
        TabbedContentAction.CloseAction closeTabAction = new TabbedContentAction.CloseAction(content){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.actionPerformed(e);
                socketConsole.dispose();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/tasks/ShowAllLogFilesTask$4", "actionPerformed"));
            }
        };
        closeTabAction.getTemplatePresentation().setIcon(AllIcons.Actions.Cancel);
        toolbarGroup.add((AnAction)closeTabAction);
        Key key = new Key(content.getDisplayName());
        key.set((UserDataHolder)this.getProject(), (Object)socketConsole);
        this.getProject().putUserData(key, (Object)socketConsole);
        CodewindToolWindow.getLogsKeyMap().put(content, (Key<SocketConsole>)key);
        simplePanel.setToolbar(ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)toolbarGroup, false).getComponent());
        String connectionId = this.application.connection.getConid();
        if (connectionId == null) {
            connectionId = "local";
        }
        final Content finalContent = content;
        CodewindToolWindow.getToolWindowUpdateHandler().addAppUpdateListener(content, connectionId, this.application.projectID, new UpdateHandler.AppUpdateListener(){

            @Override
            public void update() {
            }

            @Override
            public void remove() {
                ToolWindowManager toolWindowManager = null;
                if (!ShowAllLogFilesTask.this.getProject().isDisposed()) {
                    toolWindowManager = ToolWindowManager.getInstance((Project)ShowAllLogFilesTask.this.getProject());
                }
                if (toolWindowManager == null) {
                    return;
                }
                ToolWindow logToolWindow = toolWindowManager.getToolWindow(CodewindToolWindowHelper.SHOW_LOG_FILES_TOOLWINDOW_ID);
                if (logToolWindow != null) {
                    final ContentManager contentManager = logToolWindow.getContentManager();
                    final Content content = contentManager.findContent(CodewindCoreBundle.message("LogFileConsoleName", ((ShowAllLogFilesTask)ShowAllLogFilesTask.this).application.name, logInfo.logName));
                    CoreUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (finalContent == content && content != null) {
                                contentManager.removeContent(content, true);
                            }
                        }
                    });
                }
            }
        });
        return socketConsole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/eclipse/codewind/intellij/ui/tasks/ShowAllLogFilesTask", "run"));
    }
}

