/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.connection;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.InstallStatus;
import org.eclipse.codewind.intellij.core.cli.InstallUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.json.JSONException;

public class LocalConnection
extends CodewindConnection {
    public static final String CONNECTION_ID = "local";
    private InstallStatus installStatus = InstallStatus.UNKNOWN;
    private InstallerStatus installerStatus = null;

    public LocalConnection(String name, URI uri) {
        super(name, uri, CONNECTION_ID, null);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public InstallStatus getInstallStatus() {
        return this.installStatus;
    }

    public synchronized void refreshInstallStatus() {
        String url = null;
        try {
            this.installStatus = InstallUtil.getInstallStatus();
            if (!this.installStatus.isStarted()) {
                this.disconnect();
                this.setBaseUri(null);
            } else if (!this.isConnected()) {
                URI uri = new URI(this.installStatus.getURL());
                this.setBaseUri(uri);
                this.connect();
            }
            return;
        }
        catch (IOException e) {
            Logger.logWarning("An error occurred trying to get the installer status", e);
        }
        catch (TimeoutException e) {
            Logger.logWarning("Timed out trying to get the installer status", e);
        }
        catch (JSONException e) {
            Logger.logWarning("The Codewind installer status format is not recognized", e);
        }
        catch (URISyntaxException e) {
            Logger.logWarning("The Codewind installer status command returned an invalid url: " + url, e);
        }
        this.installStatus = InstallStatus.UNKNOWN;
    }

    public InstallerStatus getInstallerStatus() {
        return this.installerStatus;
    }

    public void setInstallerStatus(InstallerStatus status) {
        this.installerStatus = status;
        CoreUtil.updateAll();
    }

    public static enum InstallerStatus {
        INSTALLING,
        UNINSTALLING,
        STARTING,
        STOPPING;

    }
}

