/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.cli.InstallStatus;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tasks.InstallCodewindTask;
import org.eclipse.codewind.intellij.ui.tasks.UpgradeCodewindTask;

public class InstallCodewindStep
extends ModuleWizardStep {
    private final JPanel panel = new JPanel();
    private final JLabel label;
    private final JButton button;
    private boolean isInstalled;

    public InstallCodewindStep() {
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.label = new JLabel(CodewindUIBundle.message("CodewindNotInstalled", new Object[0]));
        this.label.setAlignmentX(0.0f);
        this.panel.add(this.label);
        String buttonLabel = null;
        LocalConnection localConnection = ConnectionManager.getManager().getLocalConnection();
        InstallStatus status = localConnection.getInstallStatus();
        buttonLabel = status.hasInstalledVersions() ? CodewindUIBundle.message("UpgradeCodewind", new Object[0]) : CodewindUIBundle.message("InstallCodewind", new Object[0]);
        this.button = new JButton(buttonLabel);
        this.panel.add(this.button);
        this.button.addActionListener(e -> {
            localConnection.refreshInstallStatus();
            if (status.isInstalled()) {
                CoreUtil.openDialog(CoreUtil.DialogType.INFO, CodewindUIBundle.message("CodewindLabel", new Object[0]), CodewindUIBundle.message("CodewindInstalledStarted", new Object[0]));
            } else if (status.hasInstalledVersions()) {
                ProgressManager.getInstance().run((Task)new UpgradeCodewindTask(this::onInstall));
            } else {
                ProgressManager.getInstance().run((Task)new InstallCodewindTask(this::onInstall));
            }
        });
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updateDataModel() {
    }

    public boolean validate() throws ConfigurationException {
        return this.isInstalled;
    }

    private void onInstall() {
        this.isInstalled = true;
        this.button.setEnabled(false);
        String txt = "<html>" + CodewindUIBundle.message("CodewindInstalledStarted", new Object[0]) + "</html>";
        this.label.setText(txt);
    }
}

