/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CodewindObjectFactory;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.console.ProjectLogInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.core.constants.StartMode;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindApplicationFactory {
    public static void getAppsFromProjectsJson(CodewindConnection connection, String projectsJson) {
        CodewindApplicationFactory.getAppsFromProjectsJson(connection, projectsJson, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void getAppsFromProjectsJson(CodewindConnection connection, String projectsJson, String projectID) {
        try {
            Logger.log(projectsJson);
            JSONArray appArray = new JSONArray(projectsJson);
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < appArray.length(); ++i) {
                JSONObject appJso = appArray.getJSONObject(i);
                try {
                    String id = appJso.getString("projectID");
                    idSet.add(id);
                    if (projectID != null && !projectID.equals(id)) continue;
                    Class<CodewindApplicationFactory> clazz = CodewindApplicationFactory.class;
                    // MONITORENTER : org.eclipse.codewind.intellij.core.CodewindApplicationFactory.class
                    CodewindApplication app = connection.getAppByID(id);
                    if (app != null) {
                        CodewindApplicationFactory.updateApp(app, appJso);
                        if (app.isDeleting()) {
                            connection.removeApp(id);
                        }
                    } else {
                        app = CodewindApplicationFactory.createApp(connection, appJso);
                        if (app != null && !app.isDeleting()) {
                            connection.addApp(app);
                        }
                    }
                    // MONITOREXIT : clazz
                    continue;
                }
                catch (Exception e) {
                    Logger.logWarning("Error parsing project json: " + appJso, e);
                }
            }
            if (projectID != null) return;
            Iterator<String> iterator = connection.getAppIds().iterator();
            while (iterator.hasNext()) {
                String id = iterator.next();
                if (idSet.contains(id)) continue;
                Logger.log("The application is no longer in the project list so removing: " + id);
                connection.removeApp(id);
            }
            return;
        }
        catch (Exception e) {
            Logger.logWarning("Error parsing json for project array.", e);
        }
    }

    public static CodewindApplication createApp(CodewindConnection connection, JSONObject appJso) {
        try {
            String name = appJso.getString("name");
            String id = appJso.getString("projectID");
            JSONObject extension = null;
            if (appJso.has("extension")) {
                extension = appJso.getJSONObject("extension");
            }
            ProjectType type = ProjectType.TYPE_UNKNOWN;
            ProjectLanguage language = ProjectLanguage.LANGUAGE_UNKNOWN;
            try {
                String typeStr = appJso.getString("projectType");
                String languageStr = appJso.getString("language");
                type = ProjectType.getType(typeStr, extension);
                language = ProjectLanguage.getLanguage(languageStr);
            }
            catch (JSONException e) {
                Logger.logWarning(e.getMessage() + " in: " + appJso);
            }
            String localPath = appJso.getString("locOnDisk");
            localPath = CoreUtil.getHostPath(localPath);
            CodewindApplication app = CodewindObjectFactory.createCodewindApplication(connection, id, name, type, language, Paths.get(localPath, new String[0]));
            CodewindApplicationFactory.updateApp(app, appJso);
            return app;
        }
        catch (JSONException e) {
            Logger.logWarning("Error parsing project json: " + appJso, e);
        }
        catch (Exception e) {
            Logger.logWarning("Error creating new application for project.", e);
        }
        return null;
    }

    public static void updateApp(CodewindApplication app, JSONObject appJso) {
        try {
            String detail;
            String state;
            if (appJso.has("action")) {
                String action = appJso.getString("action");
                app.setAction(action);
                if ("deleting".equals(action)) {
                    return;
                }
            } else {
                app.setAction(null);
            }
            if (appJso.has("state") && "closed".equals(state = appJso.getString("state"))) {
                app.setEnabled(false);
                return;
            }
            app.setEnabled(true);
            if (appJso.has("appStatus")) {
                JSONObject detailObj;
                String appStatus = appJso.getString("appStatus");
                detail = null;
                if (appJso.has("detailedAppStatus") && (detailObj = appJso.getJSONObject("detailedAppStatus")) != null && detailObj.has("message")) {
                    detail = detailObj.getString("message");
                    if (detailObj.has("notify") && detailObj.getBoolean("notify")) {
                        CoreUtil.DialogType type = CoreUtil.DialogType.ERROR;
                        if (detailObj.has("severity")) {
                            String severity = detailObj.getString("severity");
                            if ("WARN".equals(severity)) {
                                type = CoreUtil.DialogType.WARN;
                            } else if ("INFO".equals(severity)) {
                                type = CoreUtil.DialogType.INFO;
                            }
                        }
                        CoreUtil.openDialog(type, CodewindCoreBundle.message("ProjectErrorTitle", app.name), detail);
                    }
                }
                app.setAppStatus(appStatus, detail);
            }
            if (appJso.has("buildStatus")) {
                String buildStatus = appJso.getString("buildStatus");
                detail = "";
                if (appJso.has("detailedBuildStatus")) {
                    detail = appJso.getString("detailedBuildStatus");
                }
                app.setBuildStatus(buildStatus, detail);
            }
            if (appJso.has("lastbuild")) {
                long timestamp = appJso.getLong("lastbuild");
                app.setLastBuild(timestamp);
            }
            if (appJso.has("appImageLastBuild")) {
                String timestamp = appJso.getString("appImageLastBuild");
                try {
                    app.setLastImageBuild(Long.parseLong(timestamp));
                }
                catch (NumberFormatException e) {
                    Logger.logWarning("Error parsing the app image last build value: " + timestamp, e);
                }
            }
            String appBaseUrl = null;
            if (appJso.has("appBaseURL")) {
                appBaseUrl = appJso.getString("appBaseURL");
            }
            app.setAppBaseUrl(appBaseUrl);
            boolean isHttps = false;
            if (appJso.has("isHttps")) {
                isHttps = appJso.getBoolean("isHttps");
            }
            app.setIsHttps(isHttps);
            String containerId = null;
            if (appJso.has("containerId")) {
                containerId = appJso.getString("containerId");
            }
            app.setContainerId(containerId);
            try {
                String debugPort;
                String httpPort;
                JSONObject portsObj = null;
                if (appJso.has("ports") && appJso.get("ports") instanceof JSONObject) {
                    portsObj = appJso.getJSONObject("ports");
                }
                int httpPortNum = -1;
                if (portsObj != null && portsObj.has("exposedPort") && (httpPort = portsObj.getString("exposedPort")) != null && !httpPort.isEmpty()) {
                    httpPortNum = CoreUtil.parsePort(httpPort);
                }
                app.setHttpPort(httpPortNum);
                String internalAppPort = null;
                if (portsObj != null && portsObj.has("internalPort")) {
                    internalAppPort = portsObj.getString("internalPort");
                }
                app.setContainerAppPort(internalAppPort);
                int debugPortNum = -1;
                if (portsObj != null && portsObj.has("exposedDebugPort") && (debugPort = portsObj.getString("exposedDebugPort")) != null && !debugPort.isEmpty()) {
                    debugPortNum = CoreUtil.parsePort(debugPort);
                }
                app.setDebugPort(debugPortNum);
                String internalDebugPort = null;
                if (portsObj != null && portsObj.has("internalDebugPort")) {
                    internalDebugPort = portsObj.getString("internalDebugPort");
                }
                app.setContainerDebugPort(internalDebugPort);
            }
            catch (Exception e) {
                Logger.logWarning("Failed to get the ports for application: " + app.name, e);
            }
            String contextRoot = null;
            if (appJso.has("contextRoot")) {
                contextRoot = appJso.getString("contextRoot");
            } else if (appJso.has("contextroot")) {
                contextRoot = appJso.getString("contextroot");
            }
            app.setContextRoot(contextRoot);
            StartMode startMode = StartMode.get(appJso);
            app.setStartMode(startMode);
            if (appJso.has("autoBuild")) {
                boolean autoBuild = appJso.getBoolean("autoBuild");
                app.setAutoBuild(autoBuild);
            }
        }
        catch (JSONException e) {
            Logger.logWarning("Error parsing project json: " + appJso, e);
        }
        try {
            List<ProjectLogInfo> logInfos = app.connection.requestProjectLogs(app);
            app.setLogInfos(logInfos);
        }
        catch (Exception e) {
            Logger.logWarning("An error occurred while updating the log information for project: " + app.name, e);
        }
        boolean metricsAvailable = true;
        try {
            JSONObject obj = app.connection.requestProjectMetricsStatus(app);
            if (obj != null && obj.has("metricsAvailable")) {
                metricsAvailable = obj.getBoolean("metricsAvailable");
            }
        }
        catch (Exception e) {
            Logger.logWarning("An error occurred checking if metrics are available: " + app.name, e);
        }
        app.setMetricsAvailable(metricsAvailable);
    }
}

