/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.IUpdateHandler;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;

public class CoreUtil {
    private static final String ENV_PATH_PROPERTY = "org.eclipse.codewind.envPath";
    private static IUpdateHandler updateHandler;
    private static IUpdateHandler toolWindowUpdateHandler;

    public static void openDialog(boolean isError, String title, String msg) {
        CoreUtil.openDialog(isError ? DialogType.ERROR : DialogType.INFO, title, msg);
    }

    public static void openDialog(DialogType type, String title, String msg) {
        switch (type) {
            case ERROR: {
                CoreUtil.invokeLater(() -> Messages.showErrorDialog((String)msg, (String)title));
                break;
            }
            case WARN: {
                CoreUtil.invokeLater(() -> Messages.showWarningDialog((String)msg, (String)title));
                break;
            }
            case INFO: {
                CoreUtil.invokeLater(() -> Messages.showInfoMessage((String)msg, (String)title));
            }
        }
    }

    public static String readAllFromStream(InputStream stream) {
        Scanner s = new Scanner(stream);
        s.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    public static String getHostPath(String containerPath) {
        String hostPath = containerPath;
        if (CoreUtil.isWindows() && containerPath.startsWith("/")) {
            String device = containerPath.substring(1, 2);
            hostPath = device + ":" + containerPath.substring(2);
        }
        return hostPath;
    }

    public static String getContainerPath(String hostPath) {
        String containerPath = hostPath;
        if (CoreUtil.isWindows() && hostPath.indexOf(58) == 1) {
            containerPath = "/" + hostPath.charAt(0) + hostPath.substring(2);
            containerPath = containerPath.replaceAll("\\\\", "/");
        }
        return containerPath;
    }

    public static Path appendPathWithoutDupe(Path start, String finish) {
        Path finishPath;
        if (finish.charAt(0) == File.separatorChar || finish.charAt(0) == '/') {
            finish = finish.substring(1);
        }
        if (start.endsWith((finishPath = Paths.get(finish, new String[0])).getName(0))) {
            start = start.getParent();
        }
        return start.resolve(finishPath);
    }

    public static int parsePort(String portStr) {
        try {
            return Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            Logger.logWarning(String.format("Couldn't parse port from \"%s\"", portStr), e);
            return -1;
        }
    }

    public static void invokeLater(Runnable runner, ModalityState state) {
        ApplicationManager.getApplication().invokeLater(runner, state);
    }

    public static void invokeLater(Runnable runner) {
        CoreUtil.invokeLater(runner, ModalityState.defaultModalityState());
    }

    public static void runAsync(Runnable runner) {
        CompletableFuture.runAsync(runner);
    }

    public static void updateAll() {
        IUpdateHandler handler = CoreUtil.getUpdateHandler();
        IUpdateHandler toolWindowHandler = CoreUtil.getToolWindowUpdateHandler();
        if (handler != null) {
            CoreUtil.invokeLater(handler::updateAll);
        }
        if (toolWindowHandler != null) {
            CoreUtil.invokeLater(toolWindowHandler::updateAll);
        }
    }

    public static void updateConnection(CodewindConnection connection) {
        IUpdateHandler handler = CoreUtil.getUpdateHandler();
        IUpdateHandler toolWindowHandler = CoreUtil.getToolWindowUpdateHandler();
        if (handler != null) {
            CoreUtil.invokeLater(() -> handler.updateConnection(connection));
        }
        if (toolWindowHandler != null) {
            CoreUtil.invokeLater(() -> toolWindowHandler.updateConnection(connection));
        }
    }

    public static void removeConnection(List<CodewindApplication> apps) {
        IUpdateHandler handler = CoreUtil.getUpdateHandler();
        IUpdateHandler toolWindowHandler = CoreUtil.getToolWindowUpdateHandler();
        if (handler != null) {
            CoreUtil.invokeLater(() -> handler.removeConnection(apps));
        }
        if (toolWindowHandler != null) {
            CoreUtil.invokeLater(() -> toolWindowHandler.removeConnection(apps));
        }
    }

    public static void updateApplication(CodewindApplication app) {
        IUpdateHandler handler = CoreUtil.getUpdateHandler();
        IUpdateHandler handlers = CoreUtil.getToolWindowUpdateHandler();
        if (handler != null) {
            CoreUtil.invokeLater(() -> handler.updateApplication(app));
        }
        if (handlers != null) {
            CoreUtil.invokeLater(() -> handlers.updateApplication(app));
        }
    }

    public static void removeApplication(CodewindApplication app) {
        IUpdateHandler handler = CoreUtil.getUpdateHandler();
        IUpdateHandler toolWindowHandler = CoreUtil.getToolWindowUpdateHandler();
        if (handler != null) {
            CoreUtil.invokeLater(() -> handler.removeApplication(app));
        }
        if (toolWindowHandler != null) {
            CoreUtil.invokeLater(() -> toolWindowHandler.removeApplication(app));
        }
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static boolean isMACOS() {
        String osName = CoreUtil.getOSName();
        return osName != null && osName.toLowerCase().contains("mac");
    }

    public static String getEnvPath() {
        String path = System.getProperty(ENV_PATH_PROPERTY);
        if (path == null || path.trim().isEmpty()) {
            if (CoreUtil.isMACOS()) {
                return "/usr/local/bin/";
            }
            return null;
        }
        path = path.trim();
        if (!(path = path.replace("\\", "/")).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static void setUpdateHandler(IUpdateHandler handler) {
        updateHandler = handler;
    }

    public static void setToolWindowUpdateHandler(IUpdateHandler handler) {
        toolWindowUpdateHandler = handler;
    }

    public static IUpdateHandler getUpdateHandler() {
        return updateHandler;
    }

    public static IUpdateHandler getToolWindowUpdateHandler() {
        return toolWindowUpdateHandler;
    }

    public static enum DialogType {
        ERROR,
        WARN,
        INFO;

    }
}

