/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.PlatformUtil;
import org.eclipse.codewind.intellij.core.ProcessHelper;
import org.eclipse.codewind.intellij.core.cli.CLIInfo;
import org.eclipse.codewind.intellij.core.cli.InstallUtil;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class CLIUtil {
    public static final Path CODEWIND_DIR = Paths.get(System.getProperty("user.home"), ".codewind");
    public static final String JSON_OPTION = "--json";
    public static final String INSECURE_OPTION = "--insecure";
    public static final String[] GLOBAL_JSON = new String[]{"--json"};
    public static final String[] GLOBAL_INSECURE = new String[]{"--insecure"};
    public static final String[] GLOBAL_JSON_INSECURE = new String[]{"--json", "--insecure"};
    public static final String CON_ID_OPTION = "--conid";
    public static final String ERROR_KEY = "error";
    public static final String ERROR_DESCRIPTION_KEY = "error_description";
    private static final String STATUS_KEY = "status";
    private static final String STATUS_MSG_KEY = "status_message";
    private static final String STATUS_OK_VALUE = "OK";
    private static final Map<PlatformUtil.OperatingSystem, String> cwctlMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final Map<PlatformUtil.OperatingSystem, String> appsodyMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final CLIInfo codewindInfo;
    private static final CLIInfo appsodyInfo;
    private static final CLIInfo[] cliInfos;

    public static Process runCWCTL(String[] globalOptions, String[] cmd, String[] options) throws IOException {
        return CLIUtil.runCWCTL(globalOptions, cmd, options, null);
    }

    public static Process runCWCTL(String[] globalOptions, String[] cmd, String[] options, String[] args) throws IOException {
        return CLIUtil.createCWCTLProcess(globalOptions, cmd, options, args).start();
    }

    @NotNull
    public static ProcessBuilder createCWCTLProcess(String[] globalOptions, String[] cmd, String[] options, String[] args) throws IOException {
        for (int i = 0; i < cliInfos.length; ++i) {
            if (cliInfos[i] == null) continue;
            cliInfos[i].setInstallPath(CLIUtil.getCLIExecutable(cliInfos[i]));
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(codewindInfo.getInstallPath());
        CLIUtil.addOptions(cmdList, globalOptions);
        CLIUtil.addOptions(cmdList, cmd);
        CLIUtil.addOptions(cmdList, options);
        CLIUtil.addOptions(cmdList, args);
        Logger.log(cmdList.stream().collect(Collectors.joining(" ")));
        String[] command = cmdList.toArray(new String[cmdList.size()]);
        ProcessBuilder builder = new ProcessBuilder(command);
        if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.MAC) {
            String pathVar = System.getenv("PATH");
            pathVar = "/usr/local/bin" + File.pathSeparator + pathVar;
            Map<String, String> env = builder.environment();
            env.put("PATH", pathVar);
        }
        ProcessBuilder processBuilder = builder;
        if (processBuilder == null) {
            CLIUtil.$$$reportNull$$$0(0);
        }
        return processBuilder;
    }

    private static void addOptions(List<String> cmdList, String[] options) {
        if (options != null) {
            for (String opt : options) {
                cmdList.add(opt);
            }
        }
    }

    public static String getCWCTLExecutable() throws IOException {
        return CLIUtil.getCLIExecutable(codewindInfo);
    }

    public static String getCLIExecutable(CLIInfo operation) throws IOException {
        String installPath = operation.getInstallPath();
        if (installPath != null && new File(installPath).exists()) {
            return installPath;
        }
        PlatformUtil.OperatingSystem os = PlatformUtil.getOS(System.getProperty("os.name"));
        Map<PlatformUtil.OperatingSystem, String> osPathMap = operation.getOSPathMap();
        if (osPathMap == null) {
            String msg = "Failed to get the list of operating specific paths for installing the executable " + operation.getInstallName();
            Logger.logWarning(msg);
            throw new IOException(msg);
        }
        String relPath = osPathMap.get((Object)os);
        if (relPath == null) {
            String msg = "Failed to get the relative path for the install executable " + operation.getInstallName();
            Logger.logWarning(msg);
            throw new IOException(msg);
        }
        String installerDir = CLIUtil.getCLIInstallDir();
        String execName = relPath.substring(relPath.lastIndexOf(47) + 1);
        String execPath = installerDir + File.separator + execName;
        if (!FileUtil.makeDir(installerDir)) {
            String msg = "Failed to make the directory for the installer utility: " + installerDir;
            Logger.logWarning(msg);
            throw new IOException(msg);
        }
        try (InputStream stream = InstallUtil.class.getClassLoader().getResourceAsStream(relPath);){
            if (stream == null) {
                throw new FileNotFoundException(relPath);
            }
            FileUtil.copyFile(stream, execPath);
            if (PlatformUtil.getOS() != PlatformUtil.OperatingSystem.WINDOWS) {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                File file = new File(execPath);
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            String string = execPath;
            return string;
        }
    }

    private static String getCLIInstallDir() {
        return CODEWIND_DIR.resolve(InstallUtil.getVersion()).toString();
    }

    public static void checkResult(String[] command, ProcessHelper.ProcessResult result, boolean checkOutput) throws IOException {
        CLIUtil.checkErrorResult(command, result);
        if (result.getExitValue() != 0) {
            String error = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
            String msg = error == null || error.isEmpty() ? String.format("The %s command exited with return code %d", Arrays.toString(command), result.getExitValue()) : String.format("The %s command exited with return code %d and error: %s", Arrays.toString(command), result.getExitValue(), error);
            Logger.logWarning(msg);
            throw new IOException(msg);
        }
        if (checkOutput && (result.getOutput() == null || result.getOutput().isEmpty())) {
            String msg = String.format("The %s command exited with return code 0 but the output was empty", Arrays.toString(command));
            Logger.logWarning(msg);
            throw new IOException(msg);
        }
    }

    private static void checkErrorResult(String[] command, ProcessHelper.ProcessResult result) throws IOException {
        try {
            if (result.getOutput() != null && !result.getOutput().isEmpty()) {
                JSONObject obj = new JSONObject(result.getOutput());
                if (obj.has(ERROR_KEY)) {
                    String msg = String.format("The %s command failed with error: %s", Arrays.toString(command), obj.getString(ERROR_DESCRIPTION_KEY));
                    Logger.logWarning(msg);
                    throw new IOException(msg);
                }
                if (obj.has(STATUS_KEY) && !STATUS_OK_VALUE.equals(obj.getString(STATUS_KEY))) {
                    String msg = String.format("The %s command failed with error: %s", Arrays.toString(command), obj.getString(STATUS_MSG_KEY));
                    Logger.logWarning(msg);
                    throw new IOException(msg);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static {
        cwctlMap.put(PlatformUtil.OperatingSystem.LINUX, "cwctl/linux/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.MAC, "cwctl/darwin/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.WINDOWS, "cwctl/windows/cwctl.exe");
        appsodyMap.put(PlatformUtil.OperatingSystem.LINUX, "cwctl/linux/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.MAC, "cwctl/darwin/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.WINDOWS, "cwctl/windows/appsody.exe");
        codewindInfo = new CLIInfo("Codewind", cwctlMap);
        appsodyInfo = new CLIInfo("Appsody", appsodyMap);
        cliInfos = new CLIInfo[]{codewindInfo, appsodyInfo};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/core/cli/CLIUtil", "createCWCTLProcess"));
    }
}

