/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.cli;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.intellij.core.CodewindManager;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.ProcessHelper;
import org.eclipse.codewind.intellij.core.cli.CLIUtil;
import org.eclipse.codewind.intellij.core.cli.InstallStatus;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class InstallUtil {
    public static final String STOP_APP_CONTAINERS_PREFSKEY = "stopAppContainers";
    public static final String STOP_APP_CONTAINERS_ALWAYS = "stopAppContainersAlways";
    public static final String STOP_APP_CONTAINERS_NEVER = "stopAppContainersNever";
    public static final String STOP_APP_CONTAINERS_PROMPT = "stopAppContainersPrompt";
    public static final String STOP_APP_CONTAINERS_DEFAULT = "stopAppContainersPrompt";
    public static final int INSTALL_TIMEOUT_DEFAULT = 300;
    public static final int UNINSTALL_TIMEOUT_DEFAULT = 60;
    public static final int START_TIMEOUT_DEFAULT = 60;
    public static final int STOP_TIMEOUT_DEFAULT = 300;
    private static final String[] INSTALL_CMD;
    private static final String[] START_CMD;
    private static final String[] STOP_CMD;
    private static final String[] STOP_ALL_CMD;
    private static final String[] STATUS_CMD;
    private static final String[] REMOVE_CMD;
    private static final String[] UPGRADE_CMD;
    private static final String INSTALL_VERSION_PROPERTIES = "install-version.properties";
    private static final String INSTALL_VERSION_KEY = "install-version";
    private static final String INSTALL_VERSION;
    private static final String TAG_OPTION = "-t";
    private static final String WORKSPACE_OPTION = "--workspace";

    public static InstallStatus getInstallStatus() throws IOException, JSONException, TimeoutException {
        ProcessHelper.ProcessResult result = InstallUtil.statusCodewind();
        if (result.getExitValue() != 0) {
            String error = result.getError();
            if (error == null || error.isEmpty()) {
                error = result.getOutput();
            }
            String msg = "Installer status command failed with rc: " + result.getExitValue() + " and error: " + error;
            Logger.logWarning(msg);
            throw new IOException(msg);
        }
        JSONObject status = new JSONObject(result.getOutput());
        return new InstallStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult startCodewind(String version, ProgressIndicator indicator) throws IOException, TimeoutException, JSONException {
        indicator.setIndeterminate(true);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            ConnectionManager.getManager().getLocalConnection().setInstallerStatus(LocalConnection.InstallerStatus.STARTING);
            process = CLIUtil.runCWCTL(null, START_CMD, new String[]{TAG_OPTION, version});
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 240);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            ConnectionManager.getManager().getLocalConnection().refreshInstallStatus();
            ConnectionManager.getManager().getLocalConnection().setInstallerStatus(null);
        }
    }

    public static ProcessHelper.ProcessResult stopCodewind(ProgressIndicator indicator) throws IOException, TimeoutException {
        indicator.setIndeterminate(true);
        try {
            ConnectionManager.getManager().getLocalConnection().disconnect();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            Logger.logWarning("Error closing socket", e);
        }
        Process process = null;
        try {
            ConnectionManager.getManager().getLocalConnection().setInstallerStatus(LocalConnection.InstallerStatus.STOPPING);
            process = CLIUtil.runCWCTL(null, STOP_ALL_CMD, null);
            ProcessHelper.ProcessResult processResult = ProcessHelper.waitForProcess(process, 500, 240);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            ConnectionManager.getManager().getLocalConnection().refreshInstallStatus();
            ConnectionManager.getManager().getLocalConnection().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult installCodewind(String version, ProgressIndicator indicator) throws IOException, TimeoutException {
        indicator.setIndeterminate(true);
        Process process = null;
        try {
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.INSTALLING);
            process = CLIUtil.runCWCTL(null, INSTALL_CMD, new String[]{TAG_OPTION, version});
            ProcessHelper.ProcessResult processResult = ProcessHelper.waitForProcess(process, 1000, 600);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().refreshInstallStatus();
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult removeCodewind(String version, ProgressIndicator indicator) throws IOException, TimeoutException {
        indicator.setIndeterminate(true);
        Process process = null;
        try {
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.UNINSTALLING);
            process = version != null ? CLIUtil.runCWCTL(null, REMOVE_CMD, new String[]{TAG_OPTION, version}) : CLIUtil.runCWCTL(null, REMOVE_CMD, null);
            ProcessHelper.ProcessResult processResult = ProcessHelper.waitForProcess(process, 500, 120);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().refreshInstallStatus();
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult upgradeWorkspace(String path, ProgressIndicator indicator) throws IOException, TimeoutException {
        indicator.setIndeterminate(true);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(null, UPGRADE_CMD, new String[]{WORKSPACE_OPTION, path});
            ProcessHelper.ProcessResult processResult = ProcessHelper.waitForProcess(process, 500, 300);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    private static ProcessHelper.ProcessResult statusCodewind() throws IOException, TimeoutException {
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON, STATUS_CMD, null);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 120);
            return processResult;
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof TimeoutException) {
                throw (TimeoutException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static String getVersion() {
        return INSTALL_VERSION;
    }

    static {
        String version;
        INSTALL_CMD = new String[]{"install"};
        START_CMD = new String[]{"start"};
        STOP_CMD = new String[]{"stop"};
        STOP_ALL_CMD = new String[]{"stop-all"};
        STATUS_CMD = new String[]{"status"};
        REMOVE_CMD = new String[]{"remove"};
        UPGRADE_CMD = new String[]{"upgrade"};
        try (InputStream stream = InstallUtil.class.getClassLoader().getResourceAsStream(INSTALL_VERSION_PROPERTIES);){
            Properties properties = new Properties();
            properties.load(stream);
            version = properties.getProperty(INSTALL_VERSION_KEY);
        }
        catch (Exception e) {
            Logger.logWarning("Reading version from \"install-version.properties file failed, defaulting to \"latest\": ", e);
            version = "latest";
        }
        INSTALL_VERSION = version;
    }
}

