/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.cli;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.ProcessHelper;
import org.eclipse.codewind.intellij.core.cli.CLIUtil;
import org.eclipse.codewind.intellij.core.constants.ProjectInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectUtil {
    private static final String PROJECT_CMD = "project";
    private static final String[] CREATE_CMD = new String[]{"project", "create"};
    private static final String[] BIND_CMD = new String[]{"project", "bind"};
    private static final String[] REMOVE_CMD = new String[]{"project", "remove"};
    private static final String[] VALIDATE_CMD = new String[]{"project", "validate"};
    private static final String URL_OPTION = "--url";
    private static final String NAME_OPTION = "--name";
    private static final String LANGUAGE_OPTION = "--language";
    private static final String TYPE_OPTION = "--type";
    private static final String PATH_OPTION = "--path";
    private static final String PROJECT_ID_OPTION = "--id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createProject(String name, String path, String url, String conid, String javaHome, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        Logger.log("createProject: javaHome = " + javaHome);
        monitor.setIndeterminate(true);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            ProcessBuilder builder = CLIUtil.createCWCTLProcess(CLIUtil.GLOBAL_JSON_INSECURE, CREATE_CMD, new String[]{PATH_OPTION, path, URL_OPTION, url, "--conid", conid}, null);
            if (javaHome != null) {
                builder.environment().put("JAVA_HOME", javaHome);
                String pathVar = builder.environment().get("PATH");
                if (pathVar == null || pathVar.isEmpty()) {
                    pathVar = System.getenv("PATH");
                }
                pathVar = javaHome + File.separator + "bin" + File.pathSeparator + pathVar;
                builder.environment().put("PATH", pathVar);
            }
            if ((result = ProcessHelper.waitForProcess(process = builder.start(), 500, 1200)).getExitValue() != 0) {
                Logger.logWarning("Project create failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logWarning("Project create had 0 return code but the output is empty");
                throw new IOException("The output from project create is empty.");
            }
            JSONObject resultJson = new JSONObject(result.getOutput());
            if (!"success".equals(resultJson.getString("status"))) {
                String msg = "Project create failed for project: " + name + " with output: " + result.getOutput();
                Logger.logWarning(msg);
                throw new IOException(msg);
            }
            if (result.getError() != null && !result.getError().trim().isEmpty()) {
                Logger.log("createProject stderr: " + result.getError().trim());
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bindProject(String name, String path, String language, String projectType, String conid, ProgressIndicator monitor) throws IOException, TimeoutException {
        monitor.setIndeterminate(true);
        Process process = null;
        try {
            String[] options = new String[]{NAME_OPTION, name, LANGUAGE_OPTION, language, TYPE_OPTION, projectType, PATH_OPTION, path, "--conid", conid};
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_INSECURE, BIND_CMD, options);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 600);
            if (result.getExitValue() != 0) {
                Logger.logWarning("Project bind failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getError() != null && !result.getError().trim().isEmpty()) {
                Logger.log("bindProject stderr: " + result.getError().trim());
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static ProjectInfo validateProject(String name, String path, String hint, String conid, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        monitor.setIndeterminate(true);
        Process process = null;
        try {
            JSONObject resultJson;
            process = hint == null ? CLIUtil.runCWCTL(CLIUtil.GLOBAL_INSECURE, VALIDATE_CMD, new String[]{PATH_OPTION, path, "--conid", conid}) : CLIUtil.runCWCTL(CLIUtil.GLOBAL_INSECURE, VALIDATE_CMD, new String[]{TYPE_OPTION, hint, PATH_OPTION, path, "--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 600);
            if (result.getExitValue() != 0) {
                Logger.logWarning("Project validate failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logWarning("Project validate had 0 return code but the output is empty");
                throw new IOException("The output from project validate is empty.");
            }
            if (result.getError() != null && !result.getError().trim().isEmpty()) {
                Logger.log("validateProject stderr: " + result.getError().trim());
            }
            if ("success".equals((resultJson = new JSONObject(result.getOutput())).getString("status")) && resultJson.has("result")) {
                JSONObject typeJson = resultJson.getJSONObject("result");
                String language = typeJson.getString("language");
                String projectType = typeJson.getString("projectType");
                ProjectInfo projectInfo = new ProjectInfo(projectType, language);
                return projectInfo;
            }
            String msg = "Validation failed for project: " + name + " with output: " + result.getOutput();
            Logger.logWarning(msg);
            throw new IOException(msg);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProject(String name, String projectId, ProgressIndicator monitor) throws IOException, TimeoutException {
        monitor.setIndeterminate(true);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, REMOVE_CMD, new String[]{PROJECT_ID_OPTION, projectId});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 600);
            if (result.getError() != null && !result.getError().trim().isEmpty()) {
                Logger.log("removeProject stderr: " + result.getError().trim());
            }
            CLIUtil.checkResult(REMOVE_CMD, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

