/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.form;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.wizard.AbstractBindProjectWizardStep;
import org.jetbrains.annotations.SystemIndependent;

public class AddExistingProjectForm {
    private JPanel contentPane;
    private JTextField pathTextField;
    private JButton browseButton;
    private JLabel browseLabel;
    private JPanel rowPanel;
    private JLabel pathLabel;
    private Project project;
    private CodewindConnection connection;
    private AbstractBindProjectWizardStep step;

    public AddExistingProjectForm(AbstractBindProjectWizardStep step, Project project, CodewindConnection connection) {
        this.step = step;
        this.project = project;
        this.connection = connection;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.browseLabel = new JLabel(CodewindUIBundle.message("SelectProjectPageDescription", new Object[0]));
        this.browseButton = new JButton();
        this.browseButton.setText(CodewindUIBundle.message("SelectProjectPageBrowseButton", new Object[0]));
        this.browseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                FileChooserDescriptor singleFolderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                singleFolderDescriptor.setTitle(CodewindUIBundle.message("SelectProjectPageFilesystemProject", new Object[0]));
                singleFolderDescriptor.setHideIgnored(true);
                singleFolderDescriptor.setShowFileSystemRoots(false);
                @SystemIndependent String basePath = AddExistingProjectForm.this.project.getBasePath();
                VirtualFile file = null;
                if (basePath != null) {
                    File projectFolder = new File(basePath);
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)projectFolder, (boolean)false);
                    file = FileChooser.chooseFile((FileChooserDescriptor)singleFolderDescriptor, (Component)AddExistingProjectForm.this.browseButton.getParent(), (Project)AddExistingProjectForm.this.project, (VirtualFile)virtualFile.getParent());
                } else {
                    VirtualFile homeFolder = VfsUtil.getUserHomeDir();
                    file = FileChooser.chooseFile((FileChooserDescriptor)singleFolderDescriptor, (Component)AddExistingProjectForm.this.browseButton.getParent(), (Project)AddExistingProjectForm.this.project, (VirtualFile)homeFolder);
                }
                if (file != null && file.getPath() != null) {
                    AddExistingProjectForm.this.pathTextField.setText(file.getPath());
                }
                if (AddExistingProjectForm.this.isProjectAlreadyAdded()) {
                    CoreUtil.openDialog(true, CodewindUIBundle.message("BindProjectErrorTitle", new Object[0]), CodewindUIBundle.message("BindProjectAlreadyExistsError", AddExistingProjectForm.this.project.getName()));
                }
                AddExistingProjectForm.this.step.fireStateChanging();
            }
        });
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public String getProjectPath() {
        return this.pathTextField.getText();
    }

    public void setProjectPath(String path) {
        this.pathTextField.setText(path);
    }

    public boolean isProjectAlreadyAdded() {
        return this.isCodewindProject(this.getProjectPath());
    }

    public boolean isCodewindProject(String basePath) {
        CodewindApplication appByLocation = this.connection.getAppByLocation(basePath);
        return appByLocation != null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.rowPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.pathTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        JButton jButton = this.browseButton;
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("SelectProjectPageBrowseButton"));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.pathLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("SelectProjectPagePathLabel"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = this.browseLabel;
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

