/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.tabs.TabbedContentAction;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.ui.CodewindToolWindow;
import org.eclipse.codewind.intellij.ui.IconCache;
import org.eclipse.codewind.intellij.ui.actions.RefreshAction;
import org.eclipse.codewind.intellij.ui.form.AppOverviewFrame;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.toolwindow.UpdateHandler;
import org.jetbrains.annotations.NotNull;

public class OpenAppOverviewTask
extends Task.Backgroundable {
    public static final String PROJECT_OVERVIEW_TOOLWINDOW_ID = "Codewind Project Overview";
    private final CodewindApplication application;

    public OpenAppOverviewTask(CodewindApplication application, Project project) {
        super(project, CodewindUIBundle.message("ACTION_OPEN_APP_OVERVIEW", new Object[0]));
        this.application = application;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            OpenAppOverviewTask.$$$reportNull$$$0(0);
        }
        final ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.getProject());
        CoreUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow overviewToolWindow = toolWindowManager.getToolWindow(OpenAppOverviewTask.PROJECT_OVERVIEW_TOOLWINDOW_ID);
                Content content = null;
                ContentManager contentManager = null;
                if (overviewToolWindow == null) {
                    overviewToolWindow = toolWindowManager.registerToolWindow(OpenAppOverviewTask.PROJECT_OVERVIEW_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM);
                    overviewToolWindow.setContentUiType(ToolWindowContentUiType.TABBED, null);
                    overviewToolWindow.setIcon(IconCache.getCachedIcon("/META-INF/pluginIcon13x13.svg"));
                    contentManager = overviewToolWindow.getContentManager();
                    contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                        public void contentRemoved(@NotNull ContentManagerEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ContentManagerEvent.ContentOperation operation = event.getOperation();
                            Content content = event.getContent();
                            if (operation.equals((Object)ContentManagerEvent.ContentOperation.remove)) {
                                String connectionId = ((OpenAppOverviewTask)OpenAppOverviewTask.this).application.connection.getConid();
                                String projectId = ((OpenAppOverviewTask)OpenAppOverviewTask.this).application.projectID;
                                if (connectionId != null && projectId != null) {
                                    CodewindToolWindow.getToolWindowUpdateHandler().removeAppUpdateListener(content, connectionId, projectId);
                                }
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/eclipse/codewind/intellij/ui/tasks/OpenAppOverviewTask$1$1", "contentRemoved"));
                        }
                    });
                } else {
                    contentManager = overviewToolWindow.getContentManager();
                    content = contentManager.findContent(((OpenAppOverviewTask)OpenAppOverviewTask.this).application.name);
                }
                if (content == null) {
                    final AppOverviewFrame form = new AppOverviewFrame(OpenAppOverviewTask.this.application, OpenAppOverviewTask.this.getProject());
                    SimpleToolWindowPanel simplePanel = new SimpleToolWindowPanel(false, true);
                    content = ContentFactory.SERVICE.getInstance().createContent((JComponent)simplePanel, ((OpenAppOverviewTask)OpenAppOverviewTask.this).application.name, true);
                    simplePanel.setContent((JComponent)form.overviewPanel);
                    content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    content.setIcon(IconCache.getCachedIcon("/META-INF/pluginIcon13x13.svg"));
                    content.setDescription(CodewindUIBundle.message("AppOverviewOfProject", ((OpenAppOverviewTask)OpenAppOverviewTask.this).application.name));
                    contentManager.addContent(content);
                    DefaultActionGroup toolbarGroup = new DefaultActionGroup();
                    RefreshAction refreshTabAction = new RefreshAction(){

                        @Override
                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            CoreUtil.runAsync(new Runnable(){

                                @Override
                                public void run() {
                                    ((OpenAppOverviewTask)OpenAppOverviewTask.this).application.connection.refreshApps(((OpenAppOverviewTask)OpenAppOverviewTask.this).application.projectID);
                                    CoreUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            form.update(OpenAppOverviewTask.this.application);
                                        }
                                    });
                                }
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/tasks/OpenAppOverviewTask$1$2", "actionPerformed"));
                        }
                    };
                    refreshTabAction.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
                    toolbarGroup.add((AnAction)refreshTabAction);
                    AnAction helpAction = new AnAction(){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            try {
                                BrowserLauncher.getInstance().browse(new URI("https://www.eclipse.org/codewind/mdt-intellij-getting-started.html"));
                            }
                            catch (URISyntaxException ex) {
                                ex.printStackTrace();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/tasks/OpenAppOverviewTask$1$3", "actionPerformed"));
                        }
                    };
                    helpAction.getTemplatePresentation().setIcon(AllIcons.Actions.Help);
                    toolbarGroup.add(helpAction);
                    TabbedContentAction.CloseAction closeTabAction = new TabbedContentAction.CloseAction(content);
                    closeTabAction.getTemplatePresentation().setIcon(AllIcons.Actions.Cancel);
                    toolbarGroup.add((AnAction)closeTabAction);
                    simplePanel.setToolbar(ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)toolbarGroup, false).getComponent());
                    String connectionId = ((OpenAppOverviewTask)OpenAppOverviewTask.this).application.connection.getConid();
                    if (connectionId == null) {
                        connectionId = "local";
                    }
                    final Content finalContent = content;
                    CodewindToolWindow.getToolWindowUpdateHandler().addAppUpdateListener(content, connectionId, ((OpenAppOverviewTask)OpenAppOverviewTask.this).application.projectID, new UpdateHandler.AppUpdateListener(){

                        @Override
                        public void update() {
                            ContentManager contentManager;
                            Content content;
                            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)OpenAppOverviewTask.this.getProject());
                            ToolWindow overviewToolWindow = toolWindowManager.getToolWindow(OpenAppOverviewTask.PROJECT_OVERVIEW_TOOLWINDOW_ID);
                            if (overviewToolWindow != null && (content = (contentManager = overviewToolWindow.getContentManager()).findContent(((OpenAppOverviewTask)OpenAppOverviewTask.this).application.name)) != null) {
                                form.update(OpenAppOverviewTask.this.application);
                            }
                        }

                        @Override
                        public void remove() {
                            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)OpenAppOverviewTask.this.getProject());
                            ToolWindow overviewToolWindow = toolWindowManager.getToolWindow(OpenAppOverviewTask.PROJECT_OVERVIEW_TOOLWINDOW_ID);
                            if (overviewToolWindow != null) {
                                final ContentManager contentManager = overviewToolWindow.getContentManager();
                                final Content content = contentManager.findContent(((OpenAppOverviewTask)OpenAppOverviewTask.this).application.name);
                                CoreUtil.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (finalContent == content && content != null) {
                                            contentManager.removeContent(content, true);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                overviewToolWindow.show(null);
                overviewToolWindow.activate(null, true, true);
                if (!contentManager.isSelected(content)) {
                    contentManager.setSelectedContent(content);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/eclipse/codewind/intellij/ui/tasks/OpenAppOverviewTask", "run"));
    }
}

