/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.wizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.ProjectUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.constants.ProjectInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.wizard.AbstractBindProjectWizardStep;
import org.eclipse.codewind.intellij.ui.wizard.BindProjectModel;
import org.eclipse.codewind.intellij.ui.wizard.ProjectFolderStep;
import org.eclipse.codewind.intellij.ui.wizard.ProjectTypeSelectionStep;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

public class ConfirmProjectTypeStep
extends AbstractBindProjectWizardStep {
    public static String STEP_ID = "ConfirmProjectTypeStep";
    private Project project;
    private CodewindConnection connection;
    private String projectPath;
    private JPanel contentPanel;
    private JTextArea descriptionLabel;
    private JTextField projectPathField;
    private JTextField typeField;
    private JTextField languageField;
    private ProjectInfo initialProjectType;
    private boolean isAcceptableLanguage = false;

    public ConfirmProjectTypeStep(@Nullable String title, Project project, CodewindConnection connection) {
        super(title);
        this.project = project;
        this.connection = connection;
    }

    @NotNull
    public Object getStepId() {
        String string = STEP_ID;
        if (string == null) {
            ConfirmProjectTypeStep.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Object getNextStepId() {
        return ProjectTypeSelectionStep.STEP_ID;
    }

    @Nullable
    public Object getPreviousStepId() {
        return ProjectFolderStep.STEP_ID;
    }

    public boolean isComplete() {
        if (this.typeField != null && this.typeField.getText().isEmpty()) {
            return false;
        }
        String languageId = this.initialProjectType.language.getId();
        boolean bl = this.isAcceptableLanguage = languageId.equals(ProjectLanguage.LANGUAGE_JAVA.getId()) || languageId.equals(ProjectLanguage.LANGUAGE_UNKNOWN.getId());
        if (!this.isAcceptableLanguage) {
            return false;
        }
        return this.projectPath != null;
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
    }

    public JComponent getComponent() {
        if (this.contentPanel != null) {
            return this.contentPanel;
        }
        this.contentPanel = new JPanel();
        GridBagLayout gl = new GridBagLayout();
        this.contentPanel.setLayout(gl);
        this.contentPanel.setAlignmentY(1.0f);
        this.descriptionLabel = new JTextArea(CodewindUIBundle.message("ProjectValidationPageMsg", ""));
        this.descriptionLabel.setWrapStyleWord(true);
        this.descriptionLabel.setLineWrap(true);
        this.descriptionLabel.setEditable(false);
        this.descriptionLabel.setOpaque(false);
        this.contentPanel.add((Component)this.descriptionLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 19, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel formPanel = new JPanel();
        formPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.contentPanel.add((Component)formPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel projectPathLabel = new JLabel(CodewindUIBundle.message("SelectProjectPagePathLabel", new Object[0]));
        formPanel.add((Component)projectPathLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.projectPathField = new JTextField();
        this.projectPathField.setEditable(false);
        this.projectPathField.setOpaque(false);
        formPanel.add((Component)this.projectPathField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        projectPathLabel.setLabelFor(this.projectPathField);
        JLabel typeLabel = new JLabel(CodewindUIBundle.message("ProjectValidationPageTypeLabel", new Object[0]));
        formPanel.add((Component)typeLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.typeField = new JTextField();
        this.typeField.setOpaque(false);
        formPanel.add((Component)this.typeField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel languageLabel = new JLabel(CodewindUIBundle.message("ProjectValidationPageLanguageLabel", new Object[0]));
        formPanel.add((Component)languageLabel, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.languageField = new JTextField();
        this.languageField.setOpaque(false);
        formPanel.add((Component)this.languageField, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel verticalSpacer = new JPanel();
        this.contentPanel.add((Component)verticalSpacer, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.descriptionLabel.setFont(this.typeField.getFont());
        return this.contentPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public void setProjectPath(String path) {
        this.projectPath = path;
        if (this.projectPathField != null) {
            this.projectPathField.setText(this.projectPath);
        }
        String name = PathUtil.getFileName((String)this.projectPath);
        this.descriptionLabel.setText(CodewindUIBundle.message("ProjectValidationPageMsg", name));
    }

    public ProjectInfo getInitialProjectInfo() {
        return this.initialProjectType;
    }

    public void validateProject() {
        final String name = PathUtil.getFileName((String)this.projectPath);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    ConfirmProjectTypeStep.this.initialProjectType = ProjectUtil.validateProject(name, ConfirmProjectTypeStep.this.projectPath, null, ConfirmProjectTypeStep.this.connection.getConid(), indicator);
                    if (ConfirmProjectTypeStep.this.initialProjectType != null) {
                        if (((ConfirmProjectTypeStep)ConfirmProjectTypeStep.this).initialProjectType.language != null) {
                            ConfirmProjectTypeStep.this.languageField.setText(((ConfirmProjectTypeStep)ConfirmProjectTypeStep.this).initialProjectType.language.getDisplayName());
                        }
                        if (((ConfirmProjectTypeStep)ConfirmProjectTypeStep.this).initialProjectType.type != null) {
                            ConfirmProjectTypeStep.this.typeField.setText(((ConfirmProjectTypeStep)ConfirmProjectTypeStep.this).initialProjectType.type.getDisplayName());
                        }
                    }
                }
                catch (IOException e) {
                    Logger.log(e);
                }
                catch (JSONException e) {
                    Logger.log(e);
                }
                catch (TimeoutException e) {
                    Logger.log(e);
                }
            }
        }, CodewindUIBundle.message("ProjectValidationAnalyzingProject", new Object[0]), false, this.project);
    }

    @Override
    protected void onStepEntering(BindProjectModel model) {
        boolean projectInfoChanged = true;
        String projectPath = model.getProjectPath();
        if (projectPath != null && projectPath.equals(this.projectPath)) {
            projectInfoChanged = false;
        }
        this.setProjectPath(model.getProjectPath());
        if (projectInfoChanged) {
            this.validateProject();
        }
    }

    @Override
    protected void onStepLeaving(BindProjectModel model) {
        model.setProjectInfo(this.getInitialProjectInfo());
    }

    @Override
    protected void postDoNextStep(BindProjectModel model) {
        String name = PathUtil.getFileName((String)this.projectPath);
        String languageId = this.initialProjectType.language.getId();
        boolean bl = this.isAcceptableLanguage = languageId.equals(ProjectLanguage.LANGUAGE_JAVA.getId()) || languageId.equals(ProjectLanguage.LANGUAGE_UNKNOWN.getId());
        if (!this.isAcceptableLanguage) {
            CoreUtil.openDialog(true, CodewindUIBundle.message("ProjectValidationPageTitle", new Object[0]), CodewindUIBundle.message("ProjectValidationPageNotJavaMsg", name));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/ui/wizard/ConfirmProjectTypeStep", "getStepId"));
    }
}

