/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindApplicationFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindSocket {
    private final CodewindConnection connection;
    public final Socket socket;
    public final URI socketUri;
    private boolean hasLostConnection = false;
    private volatile boolean hasConnected = false;
    private Set<SocketConsole> socketConsoles = new HashSet<SocketConsole>();
    private Exception previousException;
    private static final String EVENT_PROJECT_CREATION = "projectCreation";
    private static final String EVENT_PROJECT_CHANGED = "projectChanged";
    private static final String EVENT_PROJECT_STATUS_CHANGE = "projectStatusChanged";
    private static final String EVENT_PROJECT_RESTART = "projectRestartResult";
    private static final String EVENT_PROJECT_CLOSED = "projectClosed";
    private static final String EVENT_PROJECT_DELETION = "projectDeletion";
    private static final String EVENT_PROJECT_VALIDATED = "projectValidated";
    private static final String EVENT_LOG_UPDATE = "log-update";
    private static final String EVENT_PROJECT_LOGS_LIST_CHANGED = "projectLogsListChanged";
    private static final String EVENT_PROJECT_SETTINGS_CHANGED = "projectSettingsChanged";
    private static final String EVENT_PROJECT_WATCH_STATUS_CHANGED = "projectWatchStatusChanged";
    private static final String EVENT_AUTHENTICATED = "authenticated";
    private static final String EVENT_UNAUTHORIZED = "unauthorized";

    public CodewindSocket(final CodewindConnection connection) throws URISyntaxException, IOException, JSONException {
        this.connection = connection;
        URI uri = connection.getBaseURI();
        if (connection.getSocketNamespace() != null) {
            uri = uri.resolve(connection.getSocketNamespace());
        }
        this.socketUri = uri;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (connection.getAuthToken(false) != null) {
            builder.hostnameVerifier(HttpUtil.hostnameVerifier).sslSocketFactory(HttpUtil.sslContext.getSocketFactory(), HttpUtil.trustManager);
        }
        OkHttpClient okHttpClient = builder.readTimeout(0L, TimeUnit.MILLISECONDS).build();
        IO.setDefaultOkHttpCallFactory((Call.Factory)okHttpClient);
        IO.setDefaultOkHttpWebSocketFactory((WebSocket.Factory)okHttpClient);
        IO.Options opts = new IO.Options();
        opts.callFactory = okHttpClient;
        opts.webSocketFactory = okHttpClient;
        this.socket = IO.socket((URI)this.socketUri, (IO.Options)opts);
        this.socket.on("connect", new Emitter.Listener(){

            public void call(Object ... arg0) {
                try {
                    AuthToken authToken = connection.getAuthToken(false);
                    if (authToken != null && authToken.getToken() != null) {
                        JSONObject obj = new JSONObject();
                        obj.put("token", (Object)authToken.getToken());
                        CodewindSocket.this.socket.emit("authentication", new Object[]{obj});
                    }
                }
                catch (Exception e) {
                    Logger.logError("An error occurred trying to pass the authentication token to the socket", e);
                    return;
                }
                Logger.log("SocketIO connect success @ " + CodewindSocket.this.socketUri);
                if (!CodewindSocket.this.hasConnected) {
                    CodewindSocket.this.hasConnected = true;
                }
                if (CodewindSocket.this.hasLostConnection) {
                    connection.clearConnectionError();
                    CodewindSocket.this.previousException = null;
                }
            }
        }).on(EVENT_AUTHENTICATED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("SocketIO authentication successful");
            }
        }).on(EVENT_UNAUTHORIZED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.logError("SocketIO authentication failed: " + arg0[0]);
                connection.disconnect();
                CoreUtil.updateConnection(connection);
                CoreUtil.openDialog(true, Messages.Connection_ErrConnection_AuthFailedTitle, NLS.bind((String)Messages.Connection_ErrConnection_AuthFailed, (Object)connection.getName()));
            }
        }).on("connect_error", new Emitter.Listener(){

            public void call(Object ... arg0) {
                if (arg0[0] instanceof Exception) {
                    Exception e = (Exception)arg0[0];
                    if (CodewindSocket.this.previousException == null || !e.getMessage().equals(CodewindSocket.this.previousException.getMessage())) {
                        CodewindSocket.this.previousException = e;
                        Logger.logError("SocketIO Connect Error @ " + CodewindSocket.this.socketUri, e);
                    }
                }
                connection.onConnectionError();
                CodewindSocket.this.hasLostConnection = true;
            }
        }).on("error", new Emitter.Listener(){

            public void call(Object ... arg0) {
                if (arg0[0] instanceof Exception) {
                    Exception e = (Exception)arg0[0];
                    Logger.logError("SocketIO Error @ " + CodewindSocket.this.socketUri, e);
                }
            }
        }).on("message", new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("SocketIO EVENT_MESSAGE " + arg0[0].toString());
            }
        }).on(EVENT_PROJECT_CREATION, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectCreation: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectCreation(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_CHANGED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectChanged(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_SETTINGS_CHANGED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectSettingsChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectSettingsChanged(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_STATUS_CHANGE, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectStatusChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectStatusChanged(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_RESTART, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectRestartResult: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectRestart(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_CLOSED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectClosed: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectClosed(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_DELETION, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectDeletion: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectDeletion(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_LOGS_LIST_CHANGED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectLogsListChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectLogsListChanged(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_LOG_UPDATE, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log(CodewindSocket.EVENT_LOG_UPDATE);
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onLogUpdate(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_VALIDATED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectValidated: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onValidationEvent(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_WATCH_STATUS_CHANGED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectWatchStatusChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectWatchStatusChanged(event);
                }
                catch (JSONException e) {
                    Logger.logError("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        });
        this.socket.connect();
        Logger.log("Created CodewindSocket connected to " + this.socketUri);
    }

    public void close() {
        if (this.socket != null) {
            if (this.socket.connected()) {
                this.socket.disconnect();
            }
            this.socket.close();
        }
    }

    private void onProjectCreation(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        this.connection.refreshApps(projectID);
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app != null) {
            app.setEnabled(true);
        } else {
            Logger.logError("No application found matching the project id for the project creation event: " + projectID);
        }
        CoreUtil.updateConnection(this.connection);
    }

    private void onProjectChanged(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logError("No application found matching the project id for the project changed event: " + projectID);
            return;
        }
        CodewindApplicationFactory.updateApp(app, event);
        if (StartMode.DEBUG_MODES.contains((Object)app.getStartMode()) && app.getDebugPort() != -1) {
            app.reconnectDebugger();
        }
        CoreUtil.updateApplication(app);
    }

    private void onProjectSettingsChanged(JSONObject event) throws JSONException {
        String status;
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logError("No application found matching the project id for the project settings changed event: " + projectID);
            return;
        }
        app.setEnabled(true);
        if (event.has("status") && !"success".equals(status = event.getString("status"))) {
            if (event.has("error")) {
                String errorMsg = event.getString("error");
                CoreUtil.openDialog(true, Messages.ProjectSettingsUpdateErrorTitle, errorMsg);
            } else {
                Logger.logError("The project settings request failed but there is no error message in the result");
            }
            return;
        }
        if (event.has("contextRoot")) {
            app.setContextRoot(event.getString("contextRoot"));
        }
        CodewindApplicationFactory.setPorts(event, app);
        CoreUtil.updateApplication(app);
    }

    private void onProjectStatusChanged(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            this.connection.refreshApps(projectID);
            CoreUtil.updateConnection(this.connection);
            return;
        }
        CodewindApplicationFactory.updateApp(app, event);
        CoreUtil.updateApplication(app);
    }

    private void onProjectRestart(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logError("No application found matching the project id for the project restart event: " + projectID);
            return;
        }
        app.setEnabled(true);
        String status = event.getString("status");
        if (!"success".equalsIgnoreCase(status)) {
            Logger.logError("Project restart failed on the application: " + event.toString());
            CoreUtil.openDialog(true, Messages.Socket_ErrRestartingProjectDialogTitle, NLS.bind((String)Messages.Socket_ErrRestartingProjectDialogMsg, (Object)app.name, (Object)status));
            return;
        }
        if (event.has("appBaseURL")) {
            app.setAppBaseUrl(event.getString("appBaseURL"));
        }
        if (event.has("podName")) {
            app.setPodName(event.getString("podName"));
        }
        CodewindApplicationFactory.setPorts(event, app);
        StartMode startMode = StartMode.get(event);
        app.setStartMode(startMode);
        if (event.has("containerId")) {
            String containerId = event.getString("containerId");
            app.setContainerId(containerId);
        }
        CoreUtil.updateApplication(app);
        app.clearDebugger();
        if (app.readyForDebugSession()) {
            app.connectDebugger();
        }
    }

    private void onProjectClosed(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logError("No application found for project being closed: " + projectID);
            return;
        }
        app.connection.refreshApps(app.projectID);
        CoreUtil.updateApplication(app);
    }

    private void onProjectDeletion(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.log("No application found for project being deleted: " + projectID);
            return;
        }
        this.connection.removeApp(projectID);
    }

    public void registerSocketConsole(SocketConsole console) {
        Logger.log("Register socketConsole for project: " + console.app.name);
        this.socketConsoles.add(console);
    }

    public void deregisterSocketConsole(SocketConsole console) {
        this.socketConsoles.remove((Object)console);
    }

    private void onLogUpdate(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        String type = event.getString("logType");
        String logName = event.getString("logName");
        Logger.log("Update the " + logName + " log for project: " + projectID);
        for (SocketConsole console : this.socketConsoles) {
            if (!console.app.projectID.equals(projectID) || !console.logInfo.isThisLogInfo(type, logName)) continue;
            try {
                String logContents = event.getString("logs");
                boolean reset = event.getBoolean("reset");
                console.update(logContents, reset);
            }
            catch (IOException e) {
                Logger.logError("Error updating console " + console.getName(), e);
            }
        }
    }

    private void onProjectLogsListChanged(JSONObject event) throws JSONException {
        List<ProjectLogInfo> logInfos;
        JSONArray logs;
        String type;
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            this.connection.refreshApps(projectID);
            CoreUtil.updateConnection(this.connection);
            return;
        }
        if (event.has("build")) {
            type = "build";
            logs = event.getJSONArray("build");
            logInfos = CodewindConnection.getLogs(logs, type);
            app.addLogInfos(logInfos);
        }
        if (event.has("app")) {
            type = "app";
            logs = event.getJSONArray("app");
            logInfos = CodewindConnection.getLogs(logs, type);
            app.addLogInfos(logInfos);
        }
        CoreUtil.updateApplication(app);
    }

    private void onValidationEvent(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logError("No application found for project: " + projectID);
            return;
        }
        app.resetValidation();
        String status = event.getString("validationStatus");
        if ("success".equals(status)) {
            return;
        }
        if (event.has("validationResults")) {
            JSONArray results = event.getJSONArray("validationResults");
            for (int i = 0; i < results.length(); ++i) {
                JSONObject result = results.getJSONObject(i);
                String severity = result.getString("severity");
                String filename = result.getString("filename");
                String filepath = result.getString("filepath");
                String type = null;
                if (result.has("type")) {
                    type = result.getString("type");
                }
                String details = result.getString("details");
                String quickFixId = null;
                String quickFixDescription = null;
                if (result.has("quickfix") && this.supportsQuickFix(app, type, filename)) {
                    JSONObject quickFix = result.getJSONObject("quickfix");
                    quickFixId = quickFix.getString("fixID");
                    quickFixDescription = quickFix.getString("description");
                }
                if ("warning".equals(severity)) {
                    app.validationWarning(filepath, details, quickFixId, quickFixDescription);
                    continue;
                }
                app.validationError(filepath, details, quickFixId, quickFixDescription);
            }
        } else {
            Logger.log("Validation event indicates failure but no validation results,");
        }
    }

    private void onProjectWatchStatusChanged(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logError("No application found matching the project id for the project watch status changed event: " + projectID);
            return;
        }
        app.setEnabled(true);
        if (event.has("status") && !"success".equals(event.getString("status"))) {
            Logger.logError("Project watch status failure for: " + app.name + ", with id: " + app.projectID);
        }
    }

    private boolean supportsQuickFix(CodewindApplication app, String type, String filename) {
        if (!"missing".equals(type) || app.projectType == ProjectType.TYPE_DOCKER) {
            return false;
        }
        if ("Dockerfile".equals(filename)) {
            return true;
        }
        return app.projectType == ProjectType.TYPE_LIBERTY && "Dockerfile-build".equals(filename);
    }

    boolean blockUntilFirstConnection(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2500);
        int delay = 100;
        int timeout = 2500;
        int waited = 0;
        while (!this.hasConnected && waited < 2500) {
            mon.split(100);
            try {
                Thread.sleep(100L);
                if ((waited += 100) % 500 == 0) {
                    Logger.log("Waiting for CodewindSocket initial connection");
                }
            }
            catch (InterruptedException e) {
                Logger.logError(e);
            }
            if (!mon.isCanceled()) continue;
            return false;
        }
        Logger.log("CodewindSocket initialized in time ? " + this.hasConnected);
        return this.hasConnected;
    }
}

