/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.editors;

import java.net.URL;
import java.util.Date;
import java.util.Optional;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.LocalConnection;
import org.eclipse.codewind.core.internal.console.CodewindConsoleFactory;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.core.internal.constants.DetailedAppStatus;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.UIConstants;
import org.eclipse.codewind.ui.internal.actions.OpenAppAction;
import org.eclipse.codewind.ui.internal.editors.ApplicationOverviewEditorInput;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.UpdateHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class ApplicationOverviewEditorPart
extends EditorPart
implements UpdateHandler.UpdateListener {
    private static final String SETTINGS_FILE = ".cw-settings";
    private static final String JSON_EDITOR_ID = "org.eclipse.wst.json.ui.JSONEditor";
    private static final String CWSETTINGS_INFO_ID = "org.eclipse.codewind.ui.overview.ProjectSettingsInfo";
    private Composite contents;
    private String appName;
    private String connectionId;
    private String connectionName;
    private String projectId;
    private ScrolledForm form = null;
    private Composite messageComp = null;
    private Label messageLabel = null;
    private Composite sectionComp = null;
    private ProjectInfoSection projectInfoSection = null;
    private ProjectStatusSection projectStatusSection = null;
    private AppInfoSection appInfoSection = null;
    private Font boldFont;

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        ApplicationOverviewEditorInput appInput = null;
        if (input instanceof ApplicationOverviewEditorInput) {
            appInput = (ApplicationOverviewEditorInput)input;
            if (appInput.connectionId == null && appInput.connectionUri == null || appInput.projectID == null) {
                Logger.logError((String)("Invalid editor input for application overview. Connection id/uri or project id is null." + input.getClass()));
                throw new PartInitException(NLS.bind((String)Messages.AppOverviewEditorCreateError, (Object)input));
            }
        } else {
            Logger.logError((String)("The editor input is not valid for the application overview: " + input.getClass()));
            throw new PartInitException(NLS.bind((String)Messages.AppOverviewEditorCreateError, (Object)input));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.appName = appInput.projectName;
        this.connectionId = appInput.connectionId;
        if (this.connectionId == null) {
            this.connectionId = "local";
        }
        this.connectionName = appInput.connectionName;
        if (this.connectionName == null) {
            this.connectionName = LocalConnection.DEFAULT_NAME;
        }
        this.projectId = appInput.projectID;
        this.setPartName(NLS.bind((String)Messages.AppOverviewEditorPartName, (Object[])new String[]{this.appName, this.connectionName}));
        CodewindUIPlugin.getUpdateHandler().addUpdateListener(this);
    }

    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        CodewindUIPlugin.getUpdateHandler().removeUpdateListener(this);
        super.dispose();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(final Composite parent) {
        ManagedForm managedForm = new ManagedForm(parent);
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.form.getForm());
        this.form.setText(" " + this.appName + " (" + this.connectionName + ")");
        this.form.setImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.messageComp = toolkit.createComposite(this.form.getBody());
        GridLayout messageLayout = new GridLayout();
        messageLayout.verticalSpacing = 0;
        messageLayout.horizontalSpacing = 10;
        this.messageComp.setLayout((Layout)messageLayout);
        this.messageComp.setLayoutData((Object)new GridData(784));
        this.messageLabel = toolkit.createLabel(this.messageComp, "");
        this.messageLabel.setLayoutData((Object)new GridData(784));
        this.boldFont = IDEUtil.newFont(parent.getShell(), parent.getFont(), 1);
        this.sectionComp = toolkit.createComposite(this.form.getBody());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 10;
        this.sectionComp.setLayout((Layout)layout);
        this.sectionComp.setLayoutData((Object)new GridData(784));
        this.projectInfoSection = new ProjectInfoSection(this.sectionComp, toolkit, 2, 1);
        this.addSpacer(this.sectionComp, toolkit, 2, 1);
        this.projectStatusSection = new ProjectStatusSection(this.sectionComp, toolkit, 2, 1);
        this.addSpacer(this.sectionComp, toolkit, 2, 1);
        this.appInfoSection = new AppInfoSection(this.sectionComp, toolkit, 2, 1);
        this.addSpacer(this.sectionComp, toolkit, 2, 1);
        toolkit.createLabel(this.sectionComp, "", 258).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.addSpacer(this.sectionComp, toolkit, 2, 1);
        Hyperlink preferencesLink = toolkit.createHyperlink(this.sectionComp, "Control opening of overview page on project create and add", 64);
        preferencesLink.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        preferencesLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent arg0) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"CodewindParentPage", null, null);
                if (dialog != null) {
                    dialog.open();
                } else {
                    Logger.logError((String)"Could not create the preference dialog for: CodewindParentPage");
                }
            }

            public void linkEntered(HyperlinkEvent arg0) {
            }

            public void linkExited(HyperlinkEvent arg0) {
            }
        });
        Button refreshButton = new Button(this.sectionComp, 8);
        refreshButton.setText(Messages.AppOverviewEditorRefreshButton);
        refreshButton.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                final CodewindConnection conn = ApplicationOverviewEditorPart.this.getConn();
                final CodewindApplication app = ApplicationOverviewEditorPart.this.getApp(conn);
                Job job = new Job(NLS.bind((String)Messages.RefreshProjectJobLabel, (Object)app.name)){

                    protected IStatus run(IProgressMonitor monitor) {
                        app.connection.refreshApps(app.projectID);
                        Display.getDefault().asyncExec(() -> ApplicationOverviewEditorPart.this.update(conn, app));
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        CodewindConnection conn = this.getConn();
        this.update(conn, this.getApp(conn), true);
    }

    @Override
    public void update(UpdateHandler.UpdateType type, Object element) {
        CodewindApplication app;
        if (element instanceof CodewindApplication && ((CodewindApplication)element).projectID.equals(this.projectId)) {
            Display.getDefault().asyncExec(() -> {
                switch (type) {
                    case MODIFY: {
                        CodewindApplication app = (CodewindApplication)element;
                        this.update(app.connection, app);
                        break;
                    }
                    case REMOVE: {
                        this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
                    }
                }
            });
        } else if (element instanceof CodewindConnection && ((CodewindConnection)element).getConid().equals(this.connectionId)) {
            Display.getDefault().asyncExec(() -> {
                switch (type) {
                    case MODIFY: {
                        CodewindConnection conn = (CodewindConnection)element;
                        CodewindApplication app = conn.getAppByID(this.projectId);
                        this.update(conn, app);
                        break;
                    }
                    case REMOVE: {
                        this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
                    }
                }
            });
        } else if (element == null && (app = this.getApp(this.getConn())) != null) {
            Display.getDefault().asyncExec(() -> {
                switch (type) {
                    case MODIFY: {
                        this.update(app.connection, app);
                        break;
                    }
                }
            });
        }
    }

    public void update(CodewindConnection conn, CodewindApplication app) {
        this.update(conn, app, false);
    }

    public void update(CodewindConnection conn, CodewindApplication app, boolean init) {
        if (this.form.isDisposed()) {
            return;
        }
        boolean changed = false;
        if (conn == null || !conn.isConnected() || app == null) {
            changed = !this.messageComp.getVisible();
            this.messageComp.setVisible(true);
            ((GridData)this.messageComp.getLayoutData()).exclude = false;
            this.messageLabel.setText(conn == null || !conn.isConnected() ? Messages.AppOverviewEditorNoConnection : Messages.AppOverviewEditorNoApplication);
            this.sectionComp.setVisible(false);
            ((GridData)this.sectionComp.getLayoutData()).exclude = true;
        } else {
            changed = this.messageComp.getVisible();
            this.messageComp.setVisible(false);
            ((GridData)this.messageComp.getLayoutData()).exclude = true;
            this.sectionComp.setVisible(true);
            ((GridData)this.sectionComp.getLayoutData()).exclude = false;
            this.projectInfoSection.update(app);
            this.projectStatusSection.update(app);
            this.appInfoSection.update(app);
        }
        if (init || changed) {
            this.form.layout(true, true);
            this.form.reflow(true);
        }
    }

    private CodewindConnection getConn() {
        return CodewindConnectionManager.getConnectionById((String)this.connectionId);
    }

    private CodewindApplication getApp(CodewindConnection connection) {
        if (connection == null) {
            return null;
        }
        return connection.getAppByID(this.projectId);
    }

    private String formatTimestamp(long timestamp) {
        Date date = new Date(timestamp);
        return date.toLocaleString();
    }

    private void addSpacer(Composite composite, FormToolkit toolkit, int horizontalSpan, int verticalSpan) {
        toolkit.createLabel(composite, "").setLayoutData((Object)new GridData(4, 4, false, false, horizontalSpan, verticalSpan));
    }

    public void setFocus() {
        if (this.contents != null) {
            this.contents.setFocus();
        }
    }

    public String metricsInjectionState(boolean injectMetricsAvailable, boolean injectMetricsEnabled) {
        if (injectMetricsAvailable) {
            return injectMetricsEnabled ? Messages.AppOverviewEditorInjectMetricsOn : Messages.AppOverviewEditorInjectMetricsOff;
        }
        return Messages.AppOverviewEditorInjectMetricsUnavailable;
    }

    public static interface LinkAction {
        public void execute(String var1);
    }

    private class LinkEntry {
        private final Text text;
        private final Hyperlink link;
        private String linkUrl;

        public LinkEntry(Composite composite, FormToolkit toolkit, String name, final LinkAction action) {
            Label label = new Label(composite, 0);
            label.setFont(ApplicationOverviewEditorPart.this.boldFont);
            label.setText(name);
            this.text = new Text(composite, 74);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setText(Messages.AppOverviewEditorNotAvailable);
            this.text.setLayoutData((Object)new GridData(1, 1, false, false));
            IDEUtil.paintBackgroundToMatch((Control)this.text, (Control)composite);
            this.link = toolkit.createHyperlink(composite, "", 64);
            this.link.setVisible(false);
            GridData data = new GridData(1, 1, true, false);
            data.horizontalIndent = 2;
            data.exclude = true;
            this.link.setLayoutData((Object)data);
            this.link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    action.execute(LinkEntry.this.linkUrl);
                }
            });
        }

        public void setValue(String linkUrl, boolean visible) {
            this.linkUrl = linkUrl;
            if (linkUrl != null && !linkUrl.isEmpty()) {
                boolean changed = !this.link.getVisible() || !linkUrl.equals(this.link.getText());
                this.link.setText(linkUrl);
                IDEUtil.setControlVisibility((Control)this.link, true);
                IDEUtil.setControlVisibility((Control)this.text, false);
                if (changed) {
                    this.link.requestLayout();
                }
            } else {
                boolean changed = !this.text.getVisible();
                IDEUtil.setControlVisibility((Control)this.link, false);
                IDEUtil.setControlVisibility((Control)this.text, true);
                if (changed) {
                    this.text.requestLayout();
                }
            }
        }
    }

    public static interface BooleanAction {
        public void execute(boolean var1);
    }

    private class StringEntry {
        private final Label label;
        private final Text text;

        public StringEntry(Composite composite, String name) {
            this.label = new Label(composite, 0);
            this.label.setFont(ApplicationOverviewEditorPart.this.boldFont);
            this.label.setText(name);
            this.label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.text = new Text(composite, 74);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setLayoutData((Object)new GridData(1, 1, true, false));
            IDEUtil.paintBackgroundToMatch((Control)this.text, (Control)composite);
        }

        public void setValue(String value, boolean visible) {
            boolean changed;
            boolean bl = changed = visible != this.label.getVisible();
            if (changed) {
                IDEUtil.setControlVisibility((Control)this.label, visible);
                IDEUtil.setControlVisibility((Control)this.text, visible);
            }
            if (visible) {
                String valueText;
                String string = valueText = value != null && !value.isEmpty() ? value : Messages.AppOverviewEditorNotAvailable;
                if (!valueText.equals(this.text.getText())) {
                    this.text.setText(valueText);
                    changed = true;
                }
            }
            if (changed) {
                this.text.requestLayout();
            }
        }
    }

    private class AppInfoSection {
        private final StringEntry containerIdEntry;
        private final StringEntry podNameEntry;
        private final StringEntry namespaceEntry;
        private final LinkEntry appURLEntry;
        private final StringEntry hostAppPortEntry;
        private final StringEntry appPortEntry;
        private final StringEntry hostDebugPortEntry;
        private final StringEntry debugPortEntry;
        private final Button editButton;
        private final Button infoButton;

        public AppInfoSection(final Composite parent, FormToolkit toolkit, int hSpan, int vSpan) {
            Section section = toolkit.createSection(parent, 258);
            section.setText(Messages.AppOverviewEditorAppInfoSection);
            section.setLayoutData((Object)new GridData(4, 4, true, false, hSpan, vSpan));
            section.setExpanded(true);
            Composite composite = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 5;
            layout.marginWidth = 10;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            toolkit.paintBordersFor(composite);
            section.setClient((Control)composite);
            this.containerIdEntry = new StringEntry(composite, Messages.AppOverviewEditorContainerIdEntry);
            this.podNameEntry = new StringEntry(composite, Messages.AppOverviewEditorPodNameEntry);
            this.namespaceEntry = new StringEntry(composite, Messages.AppOverviewEditorNamespaceEntry);
            this.appURLEntry = new LinkEntry(composite, toolkit, Messages.AppOverviewEditorAppUrlEntry, url -> {
                CodewindApplication app = ApplicationOverviewEditorPart.this.getApp(ApplicationOverviewEditorPart.this.getConn());
                if (app == null) {
                    Logger.logError((String)("Could not get the application for opening in a browser: " + ApplicationOverviewEditorPart.this.appName));
                    return;
                }
                OpenAppAction.openAppInBrowser(app);
            });
            this.hostAppPortEntry = new StringEntry(composite, Messages.AppOverviewEditorHostAppPortEntry);
            this.appPortEntry = new StringEntry(composite, Messages.AppOverviewEditorAppPortEntry);
            CodewindConnection conn = ApplicationOverviewEditorPart.this.getConn();
            this.hostDebugPortEntry = conn != null && !conn.isLocal() ? new StringEntry(composite, Messages.AppOverviewEditorLocalDebugPortEntry) : new StringEntry(composite, Messages.AppOverviewEditorHostDebugPortEntry);
            this.debugPortEntry = new StringEntry(composite, Messages.AppOverviewEditorDebugPortEntry);
            Composite buttonComp = toolkit.createComposite(composite);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginTop = 20;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            buttonComp.setLayout((Layout)layout);
            buttonComp.setLayoutData((Object)new GridData(3, 3, false, false, 2, 1));
            this.editButton = new Button(buttonComp, 8);
            this.editButton.setText(Messages.AppOverviewEditorEditProjectSettings);
            this.editButton.setLayoutData((Object)new GridData(3, 2, false, false));
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IFile file;
                    CodewindApplication app = ApplicationOverviewEditorPart.this.getApp(ApplicationOverviewEditorPart.this.getConn());
                    if (app == null) {
                        Logger.logError((String)("Trying to open the settings file from the overview page but the app is not found with name: " + ApplicationOverviewEditorPart.this.appName + ", and project id: " + ApplicationOverviewEditorPart.this.projectId));
                        return;
                    }
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(app.name);
                    if (project != null && project.isAccessible() && (file = project.getFile(ApplicationOverviewEditorPart.SETTINGS_FILE)) != null && file.exists()) {
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)ApplicationOverviewEditorPart.JSON_EDITOR_ID);
                        }
                        catch (PartInitException e) {
                            Logger.logError((String)("Error trying to open project settings file: " + file), (Throwable)e);
                            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.AppOverviewEditorOpenSettingsErrorTitle, (String)NLS.bind((String)Messages.AppOverviewEditorOpenSettingsErrorMsg, (Object)((Object)e)));
                        }
                        return;
                    }
                    IPath path = app.fullLocalPath.append(ApplicationOverviewEditorPart.SETTINGS_FILE);
                    if (path.toFile().exists()) {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
                        FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)ApplicationOverviewEditorPart.JSON_EDITOR_ID);
                        }
                        catch (PartInitException e) {
                            Logger.logError((String)("Error trying to open project settings file: " + path.toOSString()), (Throwable)e);
                            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.AppOverviewEditorOpenSettingsErrorTitle, (String)NLS.bind((String)Messages.AppOverviewEditorOpenSettingsErrorMsg, (Object)((Object)e)));
                        }
                        return;
                    }
                    Logger.logError((String)("Failed to open project settings file for project: " + ApplicationOverviewEditorPart.this.appName + ", with id: " + ApplicationOverviewEditorPart.this.projectId));
                    MessageDialog.openError((Shell)parent.getShell(), (String)Messages.AppOverviewEditorOpenSettingsErrorTitle, (String)Messages.AppOverviewEditorOpenSettingsNotFound);
                }
            });
            this.infoButton = new Button(buttonComp, 8);
            this.infoButton.setText(Messages.AppOverviewEditorProjectSettingsInfo);
            this.infoButton.setLayoutData((Object)new GridData(3, 2, false, false));
            this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        IWebBrowser browser = browserSupport.createBrowser(6, ApplicationOverviewEditorPart.CWSETTINGS_INFO_ID, null, null);
                        URL url = new URL(UIConstants.CWSETTINGS_INFO_URL);
                        browser.openURL(url);
                    }
                    catch (Exception e) {
                        Logger.logError((String)("Failed to open the browser for the project settings documentation: " + UIConstants.CWSETTINGS_INFO_URL), (Throwable)e);
                    }
                }
            });
        }

        public void update(CodewindApplication app) {
            if (app.connection.isLocal()) {
                this.containerIdEntry.setValue(app.isAvailable() ? app.getContainerId() : null, true);
                this.podNameEntry.setValue(null, false);
                this.namespaceEntry.setValue(null, false);
            } else {
                this.containerIdEntry.setValue(null, false);
                this.podNameEntry.setValue(app.isAvailable() ? app.getPodName() : null, true);
                this.namespaceEntry.setValue(app.isAvailable() ? app.getNamespace() : null, true);
            }
            this.appURLEntry.setValue(app.isAvailable() && app.getRootUrl() != null ? app.getRootUrl().toString() : null, true);
            this.hostAppPortEntry.setValue(app.isAvailable() && app.getHttpPort() > 0 ? Integer.toString(app.getHttpPort()) : null, true);
            this.appPortEntry.setValue(app.isAvailable() && app.getContainerAppPort() > 0 ? Integer.toString(app.getContainerAppPort()) : null, true);
            String hostDebugPort = null;
            String debugPort = null;
            if (app.supportsDebug()) {
                if (app.getStartMode().isDebugMode()) {
                    hostDebugPort = app.isAvailable() && app.getDebugConnectPort() > 0 ? Integer.toString(app.getDebugConnectPort()) : null;
                    debugPort = app.isAvailable() && app.getContainerDebugPort() > 0 ? Integer.toString(app.getContainerDebugPort()) : null;
                } else {
                    hostDebugPort = debugPort = Messages.AppOverviewEditorNotDebugging;
                }
            } else {
                debugPort = app.getCapabilitiesReady() ? Messages.AppOverviewEditorDebugNotSupported : null;
                hostDebugPort = debugPort;
            }
            this.hostDebugPortEntry.setValue(hostDebugPort, true);
            this.debugPortEntry.setValue(debugPort, true);
            boolean hasSettingsFile = this.hasSettingsFile(app);
            IDEUtil.setControlVisibility((Control)this.editButton, hasSettingsFile);
            IDEUtil.setControlVisibility((Control)this.infoButton, hasSettingsFile);
        }

        private boolean hasSettingsFile(CodewindApplication app) {
            IFile file;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(app.name);
            if (project != null && project.isAccessible() && (file = project.getFile(ApplicationOverviewEditorPart.SETTINGS_FILE)) != null && file.exists()) {
                return true;
            }
            IPath path = app.fullLocalPath.append(ApplicationOverviewEditorPart.SETTINGS_FILE);
            return path.toFile().exists();
        }
    }

    private class ProjectStatusSection {
        private final StringEntry autoBuildEntry;
        private final StringEntry injectMetricsEntry;
        private final StringEntry appStatusEntry;
        private final StringEntry buildStatusEntry;
        private final StringEntry lastBuildEntry;
        private final StringEntry lastImageBuildEntry;
        private final Link projectLogs;
        private final Text noProjectLogs;

        public ProjectStatusSection(Composite parent, FormToolkit toolkit, int hSpan, int vSpan) {
            Section section = toolkit.createSection(parent, 258);
            section.setText(Messages.AppOverviewEditorProjectStatusSection);
            section.setLayoutData((Object)new GridData(4, 4, true, false, hSpan, vSpan));
            section.setExpanded(true);
            Composite composite = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 5;
            layout.marginWidth = 10;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            toolkit.paintBordersFor(composite);
            section.setClient((Control)composite);
            this.autoBuildEntry = new StringEntry(composite, Messages.AppOverviewEditorAutoBuildEntry);
            this.injectMetricsEntry = new StringEntry(composite, Messages.AppOverviewEditorInjectMetricsEntry);
            this.appStatusEntry = new StringEntry(composite, Messages.AppOverviewEditorAppStatusEntry);
            this.buildStatusEntry = new StringEntry(composite, Messages.AppOverviewEditorBuildStatusEntry);
            this.lastImageBuildEntry = new StringEntry(composite, Messages.AppOverviewEditorLastImageBuildEntry);
            this.lastBuildEntry = new StringEntry(composite, Messages.AppOverviewEditorLastBuildEntry);
            Label label = new Label(composite, 0);
            label.setFont(ApplicationOverviewEditorPart.this.boldFont);
            label.setText(Messages.AppOverviewEditorProjectLogs);
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.projectLogs = new Link(composite, 0);
            this.projectLogs.setText("");
            this.projectLogs.setVisible(false);
            GridData data = new GridData(1, 1, true, false);
            data.horizontalIndent = 2;
            data.exclude = true;
            this.projectLogs.setLayoutData((Object)data);
            IDEUtil.paintBackgroundToMatch((Control)this.projectLogs, (Control)composite);
            this.projectLogs.addListener(13, event -> {
                CodewindEclipseApplication app = (CodewindEclipseApplication)ApplicationOverviewEditorPart.this.getApp(ApplicationOverviewEditorPart.this.getConn());
                if (app == null) {
                    Logger.logError((String)("A log link was selected but could not find the application for the " + ApplicationOverviewEditorPart.this.connectionId + " connection with name: " + ApplicationOverviewEditorPart.this.projectId));
                    return;
                }
                Optional<ProjectLogInfo> logInfo = app.getLogInfos().stream().filter(info -> info.logName.equals(event.text)).findFirst();
                if (logInfo.isPresent()) {
                    try {
                        SocketConsole console = app.getConsole(logInfo.get());
                        if (console == null) {
                            console = CodewindConsoleFactory.createLogFileConsole((CodewindApplication)app, (ProjectLogInfo)logInfo.get());
                            app.addConsole(console);
                        }
                        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
                    }
                    catch (Exception e) {
                        Logger.logError((String)("An error occurred trying to open the " + logInfo.get().logName + "log file for application: " + ApplicationOverviewEditorPart.this.projectId), (Throwable)e);
                        MessageDialog.openError((Shell)parent.getShell(), (String)Messages.AppOverviewEditorOpenLogErrorTitle, (String)NLS.bind((String)Messages.AppOverviewEditorOpenLogErrorMsg, (Object[])new String[]{logInfo.get().logName, app.name, e.getMessage()}));
                    }
                } else {
                    Logger.logError((String)("The " + event.text + " was selected but the associated log info could not be found for the " + ApplicationOverviewEditorPart.this.projectId + " project."));
                }
            });
            this.noProjectLogs = new Text(composite, 8);
            this.noProjectLogs.setText(Messages.AppOverviewEditorNoProjectLogs);
            this.noProjectLogs.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.noProjectLogs.setLayoutData((Object)new GridData(1, 1, true, false));
            IDEUtil.paintBackgroundToMatch((Control)this.noProjectLogs, (Control)composite);
        }

        public void update(CodewindApplication app) {
            this.autoBuildEntry.setValue(app.isAutoBuild() ? Messages.AppOverviewEditorAutoBuildOn : Messages.AppOverviewEditorAutoBuildOff, true);
            this.injectMetricsEntry.setValue(ApplicationOverviewEditorPart.this.metricsInjectionState(app.canInjectMetrics(), app.isMetricsInjected()), true);
            this.appStatusEntry.setValue(this.getAppStatusString(app), true);
            this.buildStatusEntry.setValue(this.getBuildStatusString(app), true);
            long lastImageBuild = app.getLastImageBuild();
            String lastImageBuildStr = Messages.AppOverviewEditorImageNeverBuilt;
            if (lastImageBuild > 0L) {
                lastImageBuildStr = ApplicationOverviewEditorPart.this.formatTimestamp(lastImageBuild);
            }
            this.lastImageBuildEntry.setValue(lastImageBuildStr, true);
            long lastBuild = app.getLastBuild();
            String lastBuildStr = Messages.AppOverviewEditorProjectNeverBuilt;
            if (lastBuild > 0L) {
                lastBuildStr = ApplicationOverviewEditorPart.this.formatTimestamp(lastBuild);
            }
            this.lastBuildEntry.setValue(lastBuildStr, true);
            if (app.isAvailable() && !app.getLogInfos().isEmpty()) {
                StringBuilder builder = new StringBuilder();
                app.getLogInfos().stream().forEach(info -> {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append("<a>" + info.logName + "</a>");
                });
                boolean changed = !this.projectLogs.getVisible() || !builder.toString().equals(this.projectLogs.getText());
                this.projectLogs.setText(builder.toString());
                this.projectLogs.setToolTipText(Messages.AppOverviewEditorProjectLogsTooltip);
                IDEUtil.setControlVisibility((Control)this.projectLogs, true);
                IDEUtil.setControlVisibility((Control)this.noProjectLogs, false);
                if (changed) {
                    this.projectLogs.requestLayout();
                }
            } else {
                boolean changed = !this.noProjectLogs.getVisible();
                this.projectLogs.setText("");
                IDEUtil.setControlVisibility((Control)this.projectLogs, false);
                IDEUtil.setControlVisibility((Control)this.noProjectLogs, true);
                if (changed) {
                    this.noProjectLogs.requestLayout();
                }
            }
        }

        private String getAppStatusString(CodewindApplication app) {
            if (app.isAvailable()) {
                StringBuilder builder = new StringBuilder();
                builder.append(app.getAppStatus().getDisplayString(app.getStartMode()));
                DetailedAppStatus details = app.getAppStatusDetails();
                if (details != null && details.getMessage() != null) {
                    builder.append(": ");
                    if (details.getSeverity() != null) {
                        builder.append("(" + details.getSeverity().displayString + ") ");
                    }
                    builder.append(details.getMessage());
                }
                return builder.toString();
            }
            return Messages.AppOverviewEditorStatusDisabled;
        }

        private String getBuildStatusString(CodewindApplication app) {
            if (app.isAvailable()) {
                String buildStatusStr = app.getBuildStatus().getDisplayString();
                if (app.getBuildDetails() != null) {
                    buildStatusStr = buildStatusStr + " (" + app.getBuildDetails() + ")";
                }
                return buildStatusStr;
            }
            return null;
        }
    }

    private class ProjectInfoSection {
        private final StringEntry typeEntry;
        private final StringEntry languageEntry;
        private final StringEntry projectIdEntry;
        private final StringEntry locationEntry;

        public ProjectInfoSection(Composite parent, FormToolkit toolkit, int hSpan, int vSpan) {
            Section section = toolkit.createSection(parent, 258);
            section.setText(Messages.AppOverviewEditorProjectInfoSection);
            section.setLayoutData((Object)new GridData(4, 4, true, false, hSpan, vSpan));
            section.setExpanded(true);
            Composite composite = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 5;
            layout.marginWidth = 10;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            toolkit.paintBordersFor(composite);
            section.setClient((Control)composite);
            this.typeEntry = new StringEntry(composite, Messages.AppOverviewEditorTypeEntry);
            this.languageEntry = new StringEntry(composite, Messages.AppOverviewEditorLanguageEntry);
            this.projectIdEntry = new StringEntry(composite, Messages.AppOverviewEditorProjectIdEntry);
            this.locationEntry = new StringEntry(composite, Messages.AppOverviewEditorLocationEntry);
        }

        public void update(CodewindApplication app) {
            this.typeEntry.setValue(app.projectType.getDisplayName(), true);
            this.languageEntry.setValue(app.projectLanguage.getDisplayName(), true);
            this.projectIdEntry.setValue(app.projectID, true);
            this.locationEntry.setValue(app.fullLocalPath.toOSString(), true);
        }
    }
}

