/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.cli.AuthUtil;
import org.eclipse.codewind.core.internal.cli.ConnectionUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.UIConstants;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.CompositeContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class CodewindConnectionComposite
extends Composite {
    private CompositeContainer container;
    private CodewindConnection connection;
    private boolean isUpdate;
    private boolean isChanged = false;
    private Text connNameText;
    private Text connURLText;
    private Text connUserText;
    private Text connPassText;
    private String name;
    private String url;
    private String user;
    private String pass;
    private boolean isUpdating = false;

    public CodewindConnectionComposite(Composite parent, CompositeContainer container) {
        this(parent, container, null);
    }

    public CodewindConnectionComposite(Composite parent, CompositeContainer container, CodewindConnection connection) {
        super(parent, 0);
        this.container = container;
        this.connection = connection;
        this.isUpdate = connection != null;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 20;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        this.setLayout((Layout)layout);
        this.createLabel(Messages.CodewindConnectionComposite_ConnNameLabel, this, 1);
        this.connNameText = this.createConnText(this, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_UrlLabel, this, 1);
        this.connURLText = this.createConnText(this, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_UserLabel, this, 1);
        this.connUserText = this.createConnText(this, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_PasswordLabel, this, 1);
        this.connPassText = this.createConnText(this, 0x400000, 1);
        new Label((Composite)this, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Link learnMoreLink = new Link((Composite)this, 0);
        learnMoreLink.setText("<a>" + Messages.RegMgmtLearnMoreLink + "</a>");
        learnMoreLink.setLayoutData((Object)new GridData(1, 3, false, false, 1, 1));
        learnMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    URL url = new URL(UIConstants.REMOTE_SETUP_URL);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred trying to open an external browser at: " + UIConstants.TEMPLATES_INFO_URL), (Throwable)e);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, CodewindUIPlugin.MAIN_CONTEXTID);
        this.initialize();
        this.connNameText.setFocus();
    }

    private void createLabel(String labelStr, Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelStr);
        GridData data = new GridData(4, 0x1000000, false, false, horizontalSpan, 1);
        label.setLayoutData((Object)data);
    }

    private Text createConnText(Composite parent, int styles, int horizontalSpan) {
        Text text = new Text(parent, 0x800 | styles);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, horizontalSpan, 1));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (CodewindConnectionComposite.this.isUpdating) {
                    return;
                }
                CodewindConnectionComposite.this.isChanged = true;
                CodewindConnectionComposite.this.validateAndUpdate();
            }
        });
        return text;
    }

    public boolean setFocus() {
        return this.connNameText.setFocus();
    }

    private void initialize() {
        if (this.connection != null) {
            this.isUpdating = true;
            this.connNameText.setText(this.connection.getName());
            this.connURLText.setText(this.connection.getBaseURI().toString());
            this.connUserText.setText(this.connection.getUsername());
            this.isUpdating = false;
        }
    }

    private void validateAndUpdate() {
        this.validate();
        this.container.update();
    }

    private void validate() {
        String errorMsg = this.validateConnectionInfo();
        this.container.setErrorMessage(errorMsg);
    }

    private String validateConnectionInfo() {
        this.name = this.connNameText.getText().trim();
        this.url = this.connURLText.getText().trim();
        this.user = this.connUserText.getText().trim();
        this.pass = this.connPassText.getText().trim();
        if (this.name == null || this.name.isEmpty()) {
            return Messages.CodewindConnectionComposite_NoConnNameError;
        }
        CodewindConnection existingConnection = CodewindConnectionManager.getActiveConnectionByName((String)this.name);
        if (!(existingConnection == null || this.connection != null && existingConnection.getConid().equals(this.connection.getConid()))) {
            return NLS.bind((String)Messages.CodewindConnectionComposite_ConnNameInUseError, (Object)this.name);
        }
        if (!this.url.isEmpty()) {
            try {
                new URI(this.url);
            }
            catch (URISyntaxException e) {
                return NLS.bind((String)Messages.CodewindConnectionComposite_InvalidUrlError, (Object)this.url);
            }
            existingConnection = CodewindConnectionManager.getActiveConnection((String)(this.url.endsWith("/") ? this.url : this.url + "/"));
            if (!(existingConnection == null || this.connection != null && existingConnection.getConid().equals(this.connection.getConid()))) {
                return NLS.bind((String)Messages.CodewindConnectionComposite_UrlInUseError, (Object[])new String[]{existingConnection.getName(), this.url});
            }
        }
        if (this.url.isEmpty() || this.user.isEmpty()) {
            return Messages.CodewindConnectionComposite_MissingConnDetailsError;
        }
        if (this.pass.isEmpty()) {
            if (this.isUpdate) {
                return Messages.CodewindConnectionComposite_NoPasswordForUpdateError;
            }
            return Messages.CodewindConnectionComposite_MissingConnDetailsError;
        }
        return null;
    }

    public boolean canFinish() {
        return this.validateConnectionInfo() == null && (!this.isUpdate || this.isChanged);
    }

    public String getConnectionName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus createConnection(IProgressMonitor monitor) {
        String conid = null;
        this.connection = null;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            URI uri = new URI(this.url);
            conid = ConnectionUtil.addConnection((String)this.name, (String)uri.toString(), (String)this.user, (IProgressMonitor)mon.split(20));
            if (mon.isCanceled()) {
                this.removeConnection(conid);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.connection = CodewindObjectFactory.createRemoteConnection((String)this.name, (URI)uri, (String)conid, (String)this.user, null);
            AuthToken token = AuthUtil.genAuthToken((String)this.user, (String)this.pass, (String)conid, (IProgressMonitor)mon.split(30));
            if (mon.isCanceled()) {
                this.removeConnection();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.connection.setAuthToken(token);
            this.connection.connect((IProgressMonitor)mon.split(50));
            if (mon.isCanceled()) {
                this.removeConnection();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        catch (Exception e) {
            String msg = this.connection == null ? NLS.bind((String)Messages.CodewindConnectionCreateError, (Object)this.name) : NLS.bind((String)Messages.CodewindConnectionConnectError, (Object)this.name);
            Status status = new Status(4, "org.eclipse.codewind.ui", msg, (Throwable)e);
            return status;
        }
        finally {
            if (this.connection != null) {
                CodewindConnectionManager.add((CodewindConnection)this.connection);
                ViewHelper.openCodewindExplorerView();
                CodewindUIPlugin.getUpdateHandler().updateAll();
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus updateConnection(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        try {
            ConnectionUtil.updateConnection((String)this.connection.getConid(), (String)this.name, (String)this.url, (String)this.user, (IProgressMonitor)mon.split(20));
            if (mon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.connection.setName(this.name);
            this.connection.setBaseURI(new URI(this.url));
            this.connection.setUsername(this.user);
            AuthToken token = AuthUtil.genAuthToken((String)this.user, (String)this.pass, (String)this.connection.getConid(), (IProgressMonitor)mon.split(30));
            if (mon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.connection.setAuthToken(token);
            this.connection.connect((IProgressMonitor)mon.split(50));
            if (mon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.CodewindConnectionUpdateError, (Object)this.name), (Throwable)e);
            return status;
        }
        finally {
            ViewHelper.openCodewindExplorerView();
            CodewindUIPlugin.getUpdateHandler().updateConnection(this.connection);
        }
        return Status.OK_STATUS;
    }

    private void removeConnection() {
        if (this.connection == null) {
            return;
        }
        this.connection.disconnect();
        this.removeConnection(this.connection.getConid());
        this.connection = null;
    }

    private void removeConnection(String conid) {
        if (conid == null) {
            return;
        }
        try {
            ConnectionUtil.removeConnection((String)conid, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to de-register connection: " + conid), (Throwable)e);
        }
    }
}

