/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.ui.internal.actions.BindAction;
import org.eclipse.codewind.ui.internal.actions.DiagnosticsAction;
import org.eclipse.codewind.ui.internal.actions.InstallerAction;
import org.eclipse.codewind.ui.internal.actions.LocalDoubleClickAction;
import org.eclipse.codewind.ui.internal.actions.LogLevelAction;
import org.eclipse.codewind.ui.internal.actions.ManageRegistriesAction;
import org.eclipse.codewind.ui.internal.actions.ManageReposAction;
import org.eclipse.codewind.ui.internal.actions.NewProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class LocalConnectionActionProvider
extends CommonActionProvider {
    private ISelectionProvider selProvider;
    private InstallerAction installUninstallAction;
    private InstallerAction startStopAction;
    private NewProjectAction newProjectAction;
    private BindAction bindAction;
    private ManageRegistriesAction manageRegistriesAction;
    private ManageReposAction manageReposAction;
    private LocalDoubleClickAction doubleClickAction;
    private LogLevelAction logLevelAction;
    private DiagnosticsAction diagnosticsAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.selProvider = aSite.getStructuredViewer();
        this.newProjectAction = new NewProjectAction(this.selProvider);
        this.bindAction = new BindAction(this.selProvider);
        this.manageRegistriesAction = new ManageRegistriesAction(this.selProvider);
        this.manageReposAction = new ManageReposAction(this.selProvider);
        this.installUninstallAction = new InstallerAction(InstallerAction.ActionType.INSTALL_UNINSTALL, this.selProvider);
        this.startStopAction = new InstallerAction(InstallerAction.ActionType.START_STOP, this.selProvider);
        this.doubleClickAction = new LocalDoubleClickAction(this.selProvider);
        this.logLevelAction = new LogLevelAction(this.selProvider);
        this.diagnosticsAction = new DiagnosticsAction(this.selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (CodewindManager.getManager().getInstallerStatus() != null) {
            return;
        }
        this.selProvider.setSelection(this.selProvider.getSelection());
        menu.add((IAction)this.newProjectAction);
        menu.add((IAction)this.bindAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.manageRegistriesAction);
        menu.add((IAction)this.manageReposAction);
        menu.add((IContributionItem)new Separator());
        InstallStatus status = CodewindManager.getManager().getInstallStatus();
        menu.add((IAction)this.installUninstallAction);
        if (status.isInstalled()) {
            menu.add((IAction)this.startStopAction);
        }
        boolean supportSeparator = false;
        if (this.logLevelAction.showAction()) {
            menu.add((IContributionItem)new Separator());
            supportSeparator = true;
            menu.add((IAction)this.logLevelAction);
        }
        if (this.diagnosticsAction.showAction()) {
            if (!supportSeparator) {
                menu.add((IContributionItem)new Separator());
            }
            menu.add((IAction)this.diagnosticsAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.doubleClickAction);
    }
}

