/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import java.util.HashMap;
import java.util.List;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.osgi.util.NLS;

public class UtilityLaunchConfigDelegate
extends LaunchConfigurationDelegate {
    public static final String LAUNCH_CONFIG_ID = "org.eclipse.codewind.core.internal.utilityLaunchConfigurationType";
    public static final String TITLE_ATTR = "org.eclipse.codewind.core.internal.titleAttr";
    public static final String COMMAND_ATTR = "org.eclipse.codewind.core.internal.commandAttr";

    public void launch(ILaunchConfiguration config, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] command = new String[]{};
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            List commandList = config.getAttribute(COMMAND_ATTR, (List)null);
            if (commandList == null || commandList.isEmpty()) {
                Logger.logError("There was a missing or invalid command attribute for the utility launch");
                return;
            }
            command = commandList.toArray(new String[commandList.size()]);
            String title = config.getAttribute(TITLE_ATTR, (String)null);
            mon.worked(30);
            ProcessBuilder builder = new ProcessBuilder(command);
            Process p = builder.start();
            mon.worked(30);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(IProcess.ATTR_PROCESS_TYPE, "codewind.utility");
            RuntimeProcess process = new RuntimeProcess(launch, p, title, attributes);
            launch.addProcess((IProcess)process);
            mon.worked(40);
        }
        catch (Exception e) {
            monitor.setCanceled(true);
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            Status status = new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.UtilityLaunchError, (Object)CoreUtil.formatString(command, " ")), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

