/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.marker;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.marker.CodewindMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class CodewindMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        CodewindApplication app = this.getApplication(marker);
        if (app == null) {
            return null;
        }
        String quickFixId = marker.getAttribute("quickFixId", (String)null);
        String quickFixDescription = marker.getAttribute("quickFixDescription", (String)null);
        CodewindMarkerResolution resolution = new CodewindMarkerResolution(app, quickFixId, quickFixDescription);
        return new IMarkerResolution[]{resolution};
    }

    public boolean hasResolutions(IMarker marker) {
        String quickFixId = marker.getAttribute("quickFixId", (String)null);
        String quickFixDescription = marker.getAttribute("quickFixDescription", (String)null);
        if (quickFixId == null || quickFixDescription == null) {
            return false;
        }
        CodewindApplication app = this.getApplication(marker);
        return app != null;
    }

    private CodewindApplication getApplication(IMarker marker) {
        String connectionUrl = marker.getAttribute("connectionUrl", (String)null);
        String projectId = marker.getAttribute("projectId", (String)null);
        CodewindConnection connection = CodewindConnectionManager.getActiveConnection((String)connectionUrl);
        if (connection == null) {
            return null;
        }
        CodewindApplication app = connection.getAppByID(projectId);
        return app;
    }
}

