/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.ui.CodewindToolWindow;

public class CodewindToolWindowHelper {
    public static final String SHOW_LOG_FILES_TOOLWINDOW_ID = "org.eclipse.codewind.intellij.ui.logFilesToolWindow";

    public static void openWindow(final Project project) {
        CoreUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(CodewindToolWindow.ID);
                if (toolWindow != null && toolWindow.isAvailable()) {
                    toolWindow.show(null);
                    ContentManager contentManager = toolWindow.getContentManager();
                    Content content = contentManager.findContent(CodewindToolWindow.DISPLAY_NAME);
                    JComponent component = content.getComponent();
                    if (content != null && component instanceof CodewindToolWindow) {
                        CodewindToolWindow codewindToolWindow = (CodewindToolWindow)((Object)component);
                        codewindToolWindow.expandToProject(project);
                    }
                }
            }
        });
    }

    public static void openCodewindWindow(final Project project) {
        CoreUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(CodewindToolWindow.ID);
                if (toolWindow != null && toolWindow.isAvailable()) {
                    toolWindow.show(null);
                }
            }
        });
    }

    public static void setInitialProjectToSelect(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(CodewindToolWindow.ID);
        if (toolWindow != null && toolWindow.isAvailable()) {
            ContentManager contentManager = toolWindow.getContentManager();
            Content content = contentManager.findContent(CodewindToolWindow.DISPLAY_NAME);
            JComponent component = content.getComponent();
            if (content != null && component instanceof CodewindToolWindow) {
                CodewindToolWindow codewindToolWindow = (CodewindToolWindow)((Object)component);
                codewindToolWindow.setInitialSelectedProject(project);
            }
        }
    }
}

