/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppOverviewAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementDialog;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.codewind.ui.internal.wizards.ConnectionSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectPage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewCodewindProjectWizard
extends Wizard
implements INewWizard {
    private List<CodewindConnection> connections = null;
    private CodewindConnection connection = null;
    private ConnectionSelectionPage connectionPage = null;
    private NewCodewindProjectPage newProjectPage = null;

    public NewCodewindProjectWizard() {
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
    }

    public NewCodewindProjectWizard(CodewindConnection connection) {
        this();
        this.connection = connection;
    }

    public NewCodewindProjectWizard(List<CodewindConnection> connections) {
        this();
        this.connections = connections;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.NewProjectPage_ShellTitle);
        if (this.connection == null) {
            if (this.connections == null) {
                this.connections = CodewindConnectionManager.activeConnections();
            }
            if (this.connections.size() == 1) {
                this.connection = this.connections.get(0);
            } else {
                this.connectionPage = new ConnectionSelectionPage(this.connections);
                this.addPage((IWizardPage)this.connectionPage);
            }
        }
        if (this.connection != null && (this.connection.isLocal() && !this.checkInstallStatus() || !this.connection.isLocal() && !this.checkRemoteStatus())) {
            if (this.getContainer() != null) {
                this.getContainer().getShell().close();
            }
            return;
        }
        this.newProjectPage = new NewCodewindProjectPage(this.connection);
        this.addPage((IWizardPage)this.newProjectPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.connectionPage != null && this.connectionPage.isActivePage()) {
            this.connection = this.connectionPage.getConnection();
            if (this.connection.isLocal() && !this.checkInstallStatus() || !this.connection.isLocal() && !this.checkRemoteStatus()) {
                if (this.getContainer() != null) {
                    this.getContainer().getShell().close();
                }
                return null;
            }
            this.newProjectPage.setConnection(this.connection);
            return this.newProjectPage;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.newProjectPage != null) {
            return this.newProjectPage.canFinish();
        }
        return false;
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        final ProjectTemplateInfo info = this.newProjectPage.getProjectTemplateInfo();
        final String projectName = this.newProjectPage.getProjectName();
        IPath location = this.newProjectPage.getLocationPath();
        if (location != null && location.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
            location = location.append(projectName);
        }
        final IPath projectPath = location;
        if (info == null || projectName == null || projectPath == null) {
            Logger.logError((String)"The project type, name or location was null for the new project wizard");
            return false;
        }
        Job job = new Job(NLS.bind((String)Messages.NewProjectPage_CreateJobLabel, (Object)projectName)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)140);
                    if (!NewCodewindProjectWizard.this.connection.isLocal() && info.isCodewindStyle() && !NewCodewindProjectWizard.this.connection.requestHasPushRegistry()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (MessageDialog.openConfirm((Shell)NewCodewindProjectWizard.this.getShell(), (String)Messages.NoPushRegistryTitle, (String)Messages.NoPushRegistryMessage)) {
                                    RegistryManagementDialog.open(NewCodewindProjectWizard.this.getShell(), NewCodewindProjectWizard.this.connection, (IProgressMonitor)mon.split(40));
                                } else {
                                    mon.setCanceled(true);
                                }
                            }
                        });
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (!NewCodewindProjectWizard.this.connection.requestHasPushRegistry()) {
                            return new Status(4, "org.eclipse.codewind.ui", Messages.NoPushRegistryError, null);
                        }
                    }
                    mon.setWorkRemaining(100);
                    ProjectUtil.createProject((String)projectName, (String)projectPath.toOSString(), (String)info.getUrl(), (String)NewCodewindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(40));
                    if (mon.isCanceled()) {
                        NewCodewindProjectWizard.this.cleanup(projectName, projectPath, NewCodewindProjectWizard.this.connection);
                        return Status.CANCEL_STATUS;
                    }
                    ProjectUtil.bindProject((String)projectName, (String)projectPath.toOSString(), (String)info.getLanguage(), (String)info.getProjectType(), (String)NewCodewindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(40));
                    if (mon.isCanceled()) {
                        NewCodewindProjectWizard.this.cleanup(projectName, projectPath, NewCodewindProjectWizard.this.connection);
                        return Status.CANCEL_STATUS;
                    }
                    mon.split(10);
                    NewCodewindProjectWizard.this.connection.refreshApps(null);
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mon.split(10);
                    CodewindApplication app = NewCodewindProjectWizard.this.connection.getAppByName(projectName);
                    if (app != null) {
                        ImportProjectAction.importProject(app);
                        if (CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("autoOpenOverviewPage")) {
                            Display.getDefault().asyncExec(() -> OpenAppOverviewAction.openAppOverview(app));
                        }
                    } else {
                        Logger.logError((String)("Could not get the application for import: " + projectName));
                    }
                    mon.worked(10);
                    mon.done();
                    ViewHelper.openCodewindExplorerView();
                    CodewindUIPlugin.getUpdateHandler().updateConnection(NewCodewindProjectWizard.this.connection);
                    return Status.OK_STATUS;
                }
                catch (TimeoutException e) {
                    Logger.logError((String)("A timeout occurred trying to create a project with type: " + info.getUrl() + ", and name: " + projectName), (Throwable)e);
                    NewCodewindProjectWizard.this.cleanup(projectName, projectPath, NewCodewindProjectWizard.this.connection);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NewProjectPage_ProjectCreateTimeoutMsg, (Object)projectName), (Throwable)e);
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to create a project with type: " + info.getUrl() + ", and name: " + projectName), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NewProjectPage_ProjectCreateErrorMsg, (Object)projectName), (Throwable)e);
                }
            }
        };
        job.schedule();
        return true;
    }

    private void cleanup(final String projectName, final IPath projectPath, final CodewindConnection connection) {
        Job job = new Job(NLS.bind((String)Messages.ProjectCleanupJobLabel, (Object)projectName)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
                mon.split(10);
                connection.refreshApps(null);
                CodewindApplication app = connection.getAppByName(projectName);
                if (app != null) {
                    try {
                        ProjectUtil.removeProject((String)app.name, (String)app.projectID, (boolean)true, (IProgressMonitor)mon.split(20));
                    }
                    catch (Exception e) {
                        Logger.logError((String)("An error occurred while trying to remove the project after project create terminated for: " + projectName), (Throwable)e);
                        return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ProjectCleanupError, (Object)projectName), null);
                    }
                } else {
                    mon.split(20);
                    boolean success = false;
                    for (int i = 0; i < 10 && !success; ++i) {
                        try {
                            FileUtil.deleteDirectory((String)projectPath.toOSString(), (boolean)true);
                            success = true;
                            continue;
                        }
                        catch (IOException e) {
                            mon.worked(10);
                            mon.setWorkRemaining(20);
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!success) {
                        Logger.logError((String)("An error occurred while trying to cleanup the project directory after project create terminated: " + projectPath.toOSString()));
                        return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.DirectoryCleanupError, (Object)projectPath.toOSString()), null);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private boolean checkInstallStatus() {
        final CodewindManager.InstallerStatus installerStatus = CodewindManager.getManager().getInstallerStatus();
        if (installerStatus != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CodewindInstall.installerActiveDialog(installerStatus);
                }
            });
            return false;
        }
        if (!CodewindManager.getManager().getInstallStatus().isInstalled()) {
            CodewindInstall.codewindInstallerDialog();
            return false;
        }
        BindProjectWizard.setupLocalConnection(this.connection, this);
        if (!this.connection.isConnected()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.NewProjectWizard_ErrorTitle, (String)NLS.bind((String)Messages.NewProjectWizard_ConnectionError, (Object)this.connection.getName()));
            return false;
        }
        return true;
    }

    private boolean checkRemoteStatus() {
        if (!this.connection.isConnected()) {
            BindProjectWizard.connectCodewind(this.connection, this);
        }
        if (!this.connection.isConnected()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.NewProjectWizard_ErrorTitle, (String)NLS.bind((String)Messages.NewProjectWizard_ConnectionError, (Object)this.connection.getName()));
            return false;
        }
        return true;
    }
}

