/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.HttpUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.console.ProjectLogInfo;
import org.eclipse.codewind.intellij.core.constants.AppStatus;
import org.eclipse.codewind.intellij.core.constants.BuildStatus;
import org.eclipse.codewind.intellij.core.constants.ProjectCapabilities;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.core.constants.StartMode;
import org.json.JSONObject;

public class CodewindApplication {
    public final CodewindConnection connection;
    public final String projectID;
    public final String name;
    public final String host;
    public final Path fullLocalPath;
    public final ProjectType projectType;
    public final ProjectLanguage projectLanguage;
    private String contextRoot;
    private StartMode startMode;
    private AppStatus appStatus;
    private String appStatusDetails;
    private BuildStatus buildStatus;
    private String buildDetails;
    private boolean autoBuild = true;
    private boolean canInjectMetrics = false;
    private boolean metricsInjected = false;
    private String metricsHosting = null;
    private String metricsPath = null;
    private String perfPath = null;
    private boolean metricsAvailable = false;
    private boolean hasConfirmedMetrics = false;
    private boolean enabled = true;
    private String containerId;
    private String podName;
    private String namespace;
    private boolean capabilitiesReady = false;
    private ProjectCapabilities projectCapabilities;
    private String action;
    private List<ProjectLogInfo> logInfos = new ArrayList<ProjectLogInfo>();
    private long lastBuild = -1L;
    private long lastImageBuild = -1L;
    private boolean isHttps = false;
    private boolean deleteContents = false;
    private final Vector<String> activeNotificationIDs = new Vector();
    private URL baseUrl;
    private String appBaseUrl;
    private URL rootUrl;
    private int httpPort = -1;
    private int debugPort = -1;
    private String containerAppPort = null;
    private String containerDebugPort = null;

    CodewindApplication(CodewindConnection connection, String id, String name, ProjectType projectType, ProjectLanguage projectLanguage, Path localPath) throws MalformedURLException {
        this.connection = connection;
        this.projectID = id;
        this.name = name;
        this.projectType = projectType;
        this.projectLanguage = projectLanguage;
        this.host = connection.getBaseURI().getHost();
        this.fullLocalPath = localPath;
        this.startMode = StartMode.RUN;
        this.appStatus = AppStatus.UNKNOWN;
        this.buildStatus = BuildStatus.UNKOWN;
    }

    private void setUrls() throws MalformedURLException {
        if (this.httpPort == -1) {
            Logger.log("Un-setting baseUrl because httpPort is not valid");
            this.baseUrl = null;
            this.rootUrl = null;
            return;
        }
        String httpStr = this.getIsHttps() ? "https" : "http";
        this.baseUrl = new URL(httpStr, this.host, this.httpPort, "");
        URL appUrl = null;
        if (this.appBaseUrl != null && !this.appBaseUrl.isEmpty()) {
            appUrl = new URL(this.appBaseUrl);
        }
        URL uRL = this.rootUrl = appUrl != null ? appUrl : this.baseUrl;
        if (this.contextRoot != null && !this.contextRoot.isEmpty()) {
            this.rootUrl = new URL(this.rootUrl, this.contextRoot);
        }
    }

    public synchronized void setAppStatus(String appStatus, String appStatusDetails) {
        if (appStatus != null) {
            this.appStatus = AppStatus.get(appStatus);
            this.appStatusDetails = appStatusDetails == null || appStatusDetails.trim().isEmpty() ? null : appStatusDetails;
        }
    }

    public synchronized void setBuildStatus(String buildStatus, String buildDetails) {
        if (buildStatus != null) {
            BuildStatus newStatus = BuildStatus.get(buildStatus);
            boolean hasChanged = newStatus != this.buildStatus;
            this.buildStatus = newStatus;
            this.buildDetails = buildDetails != null && buildDetails.trim().isEmpty() ? null : buildDetails;
            if (hasChanged && newStatus.isComplete()) {
                this.buildComplete();
            }
        }
    }

    public synchronized void setAppBaseUrl(String appBaseUrl) {
        this.appBaseUrl = appBaseUrl;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logWarning("An error occurred updating the application base url to: " + appBaseUrl, e);
        }
    }

    public synchronized void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logWarning("An error occurred updating the base url with the new context root: " + contextRoot, e);
        }
    }

    public synchronized String getContextRoot() {
        return this.contextRoot;
    }

    public synchronized void setStartMode(StartMode startMode) {
        this.startMode = startMode;
    }

    public synchronized void setAutoBuild(boolean enabled) {
        this.autoBuild = enabled;
        CoreUtil.updateApplication(this);
    }

    public synchronized void setEnabled(boolean enabled) {
        boolean reenabled = enabled && !this.enabled;
        this.enabled = enabled;
        if (reenabled) {
            this.connection.refreshApps(this.projectID);
            CoreUtil.updateApplication(this);
        } else if (!enabled) {
            this.setHttpPort(-1);
            this.setDebugPort(-1);
            this.setContainerId(null);
        }
    }

    public synchronized void setContainerId(String id) {
        this.containerId = id;
    }

    public synchronized void setPodInfo(String podName, String namespace) {
        this.podName = podName;
        this.namespace = namespace;
    }

    public synchronized void setAction(String action) {
        this.action = action;
    }

    public synchronized void addLogInfos(List<ProjectLogInfo> newLogInfos) {
        if (newLogInfos == null || newLogInfos.isEmpty()) {
            Logger.logWarning("Trying to add empty log infos to project: " + this.name);
            return;
        }
        if (this.logInfos == null || this.logInfos.isEmpty()) {
            this.logInfos = newLogInfos;
            return;
        }
        for (ProjectLogInfo newLogInfo : newLogInfos) {
            boolean found = false;
            for (ProjectLogInfo logInfo : this.logInfos) {
                if (!logInfo.logName.equals(newLogInfo.logName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.logInfos.add(newLogInfo);
        }
    }

    public synchronized void setLogInfos(List<ProjectLogInfo> logInfos) {
        if (logInfos == null) {
            Logger.logWarning("The logs should not be set to null for project: " + this.name);
            return;
        }
        this.logInfos = logInfos;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public URL getAppBaseUrl() throws MalformedURLException {
        if (this.appBaseUrl != null && !this.appBaseUrl.isEmpty()) {
            return new URL(this.appBaseUrl);
        }
        return this.baseUrl;
    }

    public URL getRootUrl() {
        return this.rootUrl;
    }

    public URL getMetricsDashboardUrl() {
        if (!this.hasMetricsDashboard()) {
            return null;
        }
        try {
            if ("project".equals(this.metricsHosting)) {
                return new URL(this.getAppBaseUrl(), this.metricsPath);
            }
            if ("performanceContainer".equals(this.metricsHosting)) {
                return this.connection.getBaseURI().resolve(this.metricsPath).toURL();
            }
            Logger.logWarning("Unrecognized metrics hosting type: " + this.metricsHosting);
        }
        catch (MalformedURLException e) {
            Logger.logWarning("An error occurred trying to construct the metrics dashboard URL", e);
        }
        return null;
    }

    public URL getPerfDashboardUrl() {
        if (!this.hasPerfDashboard()) {
            return null;
        }
        try {
            return this.connection.getBaseURI().resolve(this.perfPath).toURL();
        }
        catch (MalformedURLException e) {
            Logger.logWarning("An error occurred trying to construct the performance dashboard URL", e);
            return null;
        }
    }

    public synchronized void confirmMetricsAvailable() {
        if (this.hasConfirmedMetrics) {
            return;
        }
        this.hasConfirmedMetrics = true;
        if (!this.metricsAvailable || !this.projectType.isExtension()) {
            return;
        }
        try {
            URL metricsUrl = this.getMetricsDashboardUrl();
            if (metricsUrl == null) {
                return;
            }
            HttpUtil.HttpResult getMetricsResult = HttpUtil.get(metricsUrl.toURI());
            this.metricsAvailable = getMetricsResult.isGoodResponse;
        }
        catch (IOException | URISyntaxException e) {
            Logger.logWarning("An error occurred trying to confirm the application metrics status", e);
        }
    }

    public synchronized AppStatus getAppStatus() {
        return this.appStatus;
    }

    public synchronized String getAppStatusDetails() {
        return this.appStatusDetails;
    }

    public synchronized BuildStatus getBuildStatus() {
        return this.buildStatus;
    }

    public synchronized String getBuildDetails() {
        return this.buildDetails;
    }

    public synchronized int getHttpPort() {
        return this.httpPort;
    }

    public synchronized int getDebugPort() {
        return this.debugPort;
    }

    public synchronized StartMode getStartMode() {
        return this.startMode;
    }

    public synchronized boolean isAutoBuild() {
        return this.autoBuild;
    }

    public synchronized boolean isMetricsInjected() {
        return this.metricsInjected;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized String getContainerId() {
        return this.containerId;
    }

    public synchronized String getPodName() {
        return this.podName;
    }

    public synchronized String getNamespace() {
        return this.namespace;
    }

    public boolean isActive() {
        return this.getAppStatus() == AppStatus.STARTING || this.getAppStatus() == AppStatus.STARTED;
    }

    public boolean isRunning() {
        return this.rootUrl != null;
    }

    public boolean isDeleting() {
        return "deleting".equals(this.action);
    }

    public boolean isImporting() {
        return "validating".equals(this.action);
    }

    public boolean isAvailable() {
        return this.isEnabled() && !this.isImporting();
    }

    public List<ProjectLogInfo> getLogInfos() {
        return this.logInfos;
    }

    public boolean hasBuildLog() {
        return this.projectType != ProjectType.TYPE_NODEJS;
    }

    public synchronized boolean hasMetricsDashboard() {
        return this.metricsAvailable;
    }

    public synchronized boolean hasPerfDashboard() {
        return this.metricsAvailable && this.perfPath != null;
    }

    public synchronized void setMetricsInjectionInfo(boolean injectable, boolean injected) {
        this.canInjectMetrics = injectable;
        this.metricsInjected = injected;
    }

    public synchronized void setMetricsDashboardInfo(String hosting, String path) {
        if ((hosting == null ? this.metricsHosting == null : hosting.equals(this.metricsHosting)) && (path == null ? this.metricsPath == null : path.equals(this.metricsPath))) {
            return;
        }
        Logger.log("Updating metrics dashboard info, hosting: " + hosting + ", path: " + path);
        this.metricsHosting = hosting;
        this.metricsPath = path;
        this.metricsAvailable = hosting != null && path != null;
        this.hasConfirmedMetrics = false;
    }

    public synchronized void setPerfDashboardInfo(String path) {
        this.perfPath = path;
    }

    public synchronized void setLastBuild(long timestamp) {
        this.lastBuild = timestamp;
    }

    public synchronized long getLastBuild() {
        return this.lastBuild;
    }

    public synchronized void setLastImageBuild(long timestamp) {
        this.lastImageBuild = timestamp;
    }

    public synchronized long getLastImageBuild() {
        return this.lastImageBuild;
    }

    public synchronized void setHttpPort(int httpPort) {
        Logger.log("Set HTTP port for " + this.rootUrl + " to " + httpPort);
        this.httpPort = httpPort;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logWarning(e);
        }
    }

    public synchronized void setDebugPort(int debugPort) {
        Logger.log("Set debug port for " + this.rootUrl + " to " + debugPort);
        this.debugPort = debugPort;
    }

    public synchronized void invalidatePorts() {
        Logger.log("Invalidate ports for " + this.name);
        this.httpPort = -1;
        this.debugPort = -1;
    }

    public synchronized void setContainerAppPort(String port) {
        this.containerAppPort = port;
    }

    public synchronized String getContainerAppPort() {
        return this.containerAppPort;
    }

    public synchronized void setContainerDebugPort(String port) {
        this.containerDebugPort = port;
    }

    public synchronized String getContainerDebugPort() {
        return this.containerDebugPort;
    }

    public synchronized void setIsHttps(boolean value) {
        this.isHttps = value;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logWarning("An error occurred updating isHttps to: " + value, e);
        }
    }

    public synchronized boolean getIsHttps() {
        return this.isHttps;
    }

    public synchronized void setDeleteContents(boolean value) {
        this.deleteContents = value;
    }

    public synchronized boolean getDeleteContents() {
        return this.deleteContents;
    }

    public synchronized void setCapabilitiesReady(boolean capabilitiesReady) {
        this.capabilitiesReady = capabilitiesReady;
    }

    public synchronized boolean getCapabilitiesReady() {
        return this.capabilitiesReady;
    }

    public ProjectCapabilities getProjectCapabilities() {
        if (this.projectCapabilities == null && this.capabilitiesReady) {
            try {
                JSONObject obj = this.connection.requestProjectCapabilities(this);
                this.projectCapabilities = new ProjectCapabilities(obj);
            }
            catch (Exception e) {
                Logger.logWarning("Failed to get the project capabilities for application: " + this.name, e);
            }
        }
        if (this.projectCapabilities == null) {
            return ProjectCapabilities.emptyCapabilities;
        }
        return this.projectCapabilities;
    }

    public void clearDebugger() {
    }

    public void connectDebugger() {
    }

    public void reconnectDebugger() {
    }

    public void dispose() {
    }

    public void resetValidation() {
    }

    public void validationError(String filePath, String message, String quickFixId, String quickFixDescription) {
    }

    public void validationWarning(String filePath, String message, String quickFixId, String quickFixDescription) {
    }

    public boolean supportsDebug() {
        ProjectCapabilities capabilities = this.getProjectCapabilities();
        return (capabilities.supportsDebugMode() || capabilities.supportsDebugNoInitMode()) && capabilities.canRestart();
    }

    public void buildComplete() {
    }

    public boolean canInjectMetrics() {
        return this.canInjectMetrics;
    }

    public boolean hasNotificationID(String id) {
        Logger.log(String.format("The %s notification id for the %s application is contained: %b", id, this.name, this.activeNotificationIDs.contains(id)));
        return this.activeNotificationIDs.contains(id);
    }

    public void addNotificationID(String id) {
        Logger.log(String.format("Adding notification id %s to the %s application", id, this.name));
        this.activeNotificationIDs.add(id);
    }

    public void clearNotificationIDs() {
        Logger.log(String.format("Clearing notification ids for the %s application", this.name));
        this.activeNotificationIDs.clear();
    }

    public String toString() {
        return String.format("%s@%s id=%s name=%s type=%s loc=%s", CodewindApplication.class.getSimpleName(), this.rootUrl.toString(), this.projectID, this.name, this.projectType, this.fullLocalPath.toString());
    }

    public Path ideaProjectPath() {
        Path path = this.fullLocalPath.resolve(".idea");
        if (Files.exists(path, new LinkOption[0])) {
            return this.fullLocalPath;
        }
        path = this.fullLocalPath.resolve(".ipr");
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public CodewindConnection getConnection() {
        return this.connection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CodewindApplication)) {
            return false;
        }
        CodewindApplication other = (CodewindApplication)object;
        return this.projectID.equals(other.projectID);
    }

    public int hashCode() {
        return this.projectID.hashCode();
    }
}

