/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.constants;

import java.util.EnumSet;
import org.eclipse.codewind.intellij.core.Logger;
import org.json.JSONObject;

public enum StartMode {
    RUN("run"),
    DEBUG("debug"),
    DEBUG_NO_INIT("debugNoInit");

    public static final EnumSet<StartMode> DEBUG_MODES;
    public final String startMode;

    private StartMode(String startMode) {
        this.startMode = startMode;
    }

    public boolean equals(String s) {
        return this.name().equals(s);
    }

    public static StartMode get(String startMode) {
        for (StartMode mode : StartMode.values()) {
            if (!mode.startMode.equals(startMode)) continue;
            return mode;
        }
        return null;
    }

    public static StartMode get(JSONObject obj) {
        try {
            String mode = null;
            if (obj.has("startMode")) {
                mode = obj.getString("startMode");
            }
            if (mode == null) {
                Logger.log("No start mode was specified on JSON object");
                return RUN;
            }
            StartMode startMode = StartMode.get(mode);
            if (startMode == null) {
                Logger.log("Unrecognized start mode: " + mode);
                return RUN;
            }
            return startMode;
        }
        catch (Exception e) {
            Logger.logWarning("Failed to get start mode", e);
            return RUN;
        }
    }

    static {
        DEBUG_MODES = EnumSet.of(DEBUG, DEBUG_NO_INIT);
    }
}

