/*******************************************************************************
* Copyright (c) 2019, 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileWatcher } from "./FileWatcher";
/**
 * This class is responsible for issuing a GET request to the server in order to
 * retrieve the latest list of projects to watch (including their path, and any
 * filters).
 *
 * A new GET request will be sent by this class on startup, and after startup,
 * a GET request will be sent either:
 * - whenever the WebSocket connection fails
 * - or otherwise, once every X seconds (eg 120)
 *
 * WebSocketManagerThread is responsible for informing this class when the
 * WebSocket connection fails (input), and this class calls the Filewatcher
 * class with the data from the GET request (containing any project watch
 * updates received) as output.
 */
export declare class HttpGetStatusThread {
    static readonly REFRESH_EVERY_X_SECONDS = 120;
    private _baseUrl;
    private _inInnerLoop;
    private _timer;
    private _disposed;
    private readonly _parent;
    constructor(baseUrl: string, parent: FileWatcher);
    queueStatusUpdate(): Promise<void>;
    dispose(): void;
    private doHttpGet;
    private innerLoop;
    private resetTimer;
}
