/*******************************************************************************
* Copyright (c) 2019, 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
export declare enum EventType {
    CREATE = 1,
    MODIFY = 2,
    DELETE = 3
}
export declare function eventTypetoString(type: EventType): string;
export declare function getEventTypeFromString(str: string): EventType;
/**
 * Corresponds to an file/directory change event from the OS: a
 * creation/modification/deletion of a file, or a creation/deletion of a
 * directory.
 */
export declare class WatchEventEntry {
    private readonly _path;
    private readonly _eventType;
    private readonly _directory;
    constructor(eventType: EventType, pathParam: string, directory: boolean);
    /** For debugging only */
    toString(): string;
    readonly absolutePathWithUnixSeparators: string;
    readonly eventType: EventType;
    readonly directory: boolean;
}
