"use strict";
/*******************************************************************************
* Copyright (c) 2019, 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const log = require("./Logger");
const PathUtils = require("./PathUtils");
var EventType;
(function (EventType) {
    EventType[EventType["CREATE"] = 1] = "CREATE";
    EventType[EventType["MODIFY"] = 2] = "MODIFY";
    EventType[EventType["DELETE"] = 3] = "DELETE";
})(EventType = exports.EventType || (exports.EventType = {}));
function eventTypetoString(type) {
    if (type === EventType.CREATE) {
        return "CREATE";
    }
    else if (type === EventType.MODIFY) {
        return "MODIFY";
    }
    else if (type === EventType.DELETE) {
        return "DELETE";
    }
    else {
        const msg = "Unable to convert event type to string - " + type;
        log.severe(msg);
        throw new Error(msg);
    }
}
exports.eventTypetoString = eventTypetoString;
function getEventTypeFromString(str) {
    if (str === "CREATE") {
        return EventType.CREATE;
    }
    else if (str === "MODIFY") {
        return EventType.MODIFY;
    }
    else if (str === "DELETE") {
        return EventType.DELETE;
    }
    else {
        const msg = "Unable to find event type: this shouldn't happen - " + str;
        log.severe(msg);
        throw new Error(msg);
    }
}
exports.getEventTypeFromString = getEventTypeFromString;
/**
 * Corresponds to an file/directory change event from the OS: a
 * creation/modification/deletion of a file, or a creation/deletion of a
 * directory.
 */
class WatchEventEntry {
    constructor(eventType, pathParam, directory) {
        this._eventType = eventType;
        this._path = PathUtils.normalizePath(pathParam);
        this._directory = directory;
    }
    /** For debugging only */
    toString() {
        return "[" + eventTypetoString(this._eventType) + "] " + this._path;
    }
    get absolutePathWithUnixSeparators() {
        return this._path;
    }
    get eventType() {
        return this._eventType;
    }
    get directory() {
        return this._directory;
    }
}
exports.WatchEventEntry = WatchEventEntry;
