/*******************************************************************************
* Copyright (c) 2019, 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileWatcher } from "./FileWatcher";
import { IWatchService } from "./IWatchService";
import { WatchEventEntry } from "./WatchEventEntry";
import { ProjectToWatch } from "./ProjectToWatch";
/**
 * This class uses the directory/file monitoring functionality of the 3rd party
 * Chokidar library for file monitoring (but most of the interface with Chokidar
 * is in WatchedPath)
 *
 * See IPlatformWatchService for general information on watch services.
 */
export declare class WatchService implements IWatchService {
    private _parent;
    private readonly _watchedProjects;
    private _disposed;
    constructor();
    setParent(parent: FileWatcher): void;
    addPath(fileToMonitor: string, ptw: ProjectToWatch): void;
    removePath(fileToMonitor: string, oldProjectToWatch: ProjectToWatch): void;
    handleEvent(event: WatchEventEntry): void;
    dispose(): void;
    readonly parent: FileWatcher | undefined;
    generateDebugState(): string;
}
